/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.domain.TipoCalculo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalculoResumoDTO {
    private Long id;
    private Long exercicio;
    private String usuario;
    private TipoCalculo tipo;
    private LocalDate dataCalculo;
    private String filtroDivida;
    private String filtroCadastro;
    private SituacaoCalculo situacao;
    private Long totalCadastros;
    private Long totalCadastrosComInconsistencia;
    private LocalDate dataCancelamento;
    private String usuarioCancelamento;
    private LocalDate dataGeracaoDebito;
    private String usuarioGeracaoDebito;
    private Boolean necessitaConfigurarFormasPagamento;
    private Long jobIdSimulacao;
    private BatchStatus jobStatusSimulacao;
    private Long jobIdDebito;
    private BatchStatus jobStatusDebito;
    private BatchStatus jobStatusCarne;
    private BigDecimal totalCalculado = BigDecimal.ZERO;
    private BigDecimal totalIsencoes = BigDecimal.ZERO;
    private BigDecimal valorTotal = BigDecimal.ZERO;

    public static CalculoResumoDTO of(Calculo calculo) {
        CalculoResumoDTO resumo = new CalculoResumoDTO();
        resumo.setId(calculo.getId());
        resumo.setTipo(calculo.getTipo());
        resumo.setExercicio(calculo.getExercicio());
        resumo.setUsuario(calculo.getUsuario());
        resumo.setDataCalculo(calculo.getDataCalculo());
        resumo.setFiltroDivida(calculo.getFiltroDivida());
        resumo.setFiltroCadastro(calculo.getFiltroCadastro());
        resumo.setSituacao(calculo.getSituacao());
        resumo.setTotalCadastros(calculo.getTotalCadastros());
        resumo.setTotalCadastrosComInconsistencia(calculo.getTotalCadastrosComInconsistencia());
        resumo.setDataCancelamento(calculo.getDataCancelamento());
        resumo.setUsuarioCancelamento(calculo.getUsuarioCancelamento());
        resumo.setDataGeracaoDebito(calculo.getDataGeracaoDebito());
        resumo.setUsuarioGeracaoDebito(calculo.getUsuarioGeracaoDebito());
        resumo.setNecessitaConfigurarFormasPagamento(Boolean.valueOf(calculo.getNecessitaConfigurarFormasPagamento()));
        if (Objects.nonNull(calculo.getBatchJobExecutionSimulacao())) {
            resumo.setJobIdSimulacao(calculo.getBatchJobExecutionSimulacao().getId());
            resumo.setJobStatusSimulacao(calculo.getBatchJobExecutionSimulacao().getStatus());
        }
        if (Objects.nonNull(calculo.getBatchJobExecutionDebito())) {
            resumo.setJobIdDebito(calculo.getBatchJobExecutionDebito().getId());
            resumo.setJobStatusDebito(calculo.getBatchJobExecutionDebito().getStatus());
        }
        Optional.ofNullable(calculo.getBatchJobExecutionCarne()).ifPresent(batchJobExecutionCarne -> resumo.setJobStatusCarne(batchJobExecutionCarne.getStatus()));
        return resumo;
    }

    public static CalculoResumoDTO of(Calculo calculo, BigDecimal totalCalculado, BigDecimal totalIsencoes) {
        CalculoResumoDTO dto = CalculoResumoDTO.of((Calculo)calculo);
        dto.setTotalCalculado(totalCalculado);
        dto.setTotalIsencoes(totalIsencoes);
        dto.setValorTotal(totalCalculado.subtract(totalIsencoes));
        return dto;
    }

    @Generated
    public CalculoResumoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public TipoCalculo getTipo() {
        return this.tipo;
    }

    @Generated
    public LocalDate getDataCalculo() {
        return this.dataCalculo;
    }

    @Generated
    public String getFiltroDivida() {
        return this.filtroDivida;
    }

    @Generated
    public String getFiltroCadastro() {
        return this.filtroCadastro;
    }

    @Generated
    public SituacaoCalculo getSituacao() {
        return this.situacao;
    }

    @Generated
    public Long getTotalCadastros() {
        return this.totalCadastros;
    }

    @Generated
    public Long getTotalCadastrosComInconsistencia() {
        return this.totalCadastrosComInconsistencia;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public LocalDate getDataGeracaoDebito() {
        return this.dataGeracaoDebito;
    }

    @Generated
    public String getUsuarioGeracaoDebito() {
        return this.usuarioGeracaoDebito;
    }

    @Generated
    public Boolean getNecessitaConfigurarFormasPagamento() {
        return this.necessitaConfigurarFormasPagamento;
    }

    @Generated
    public Long getJobIdSimulacao() {
        return this.jobIdSimulacao;
    }

    @Generated
    public BatchStatus getJobStatusSimulacao() {
        return this.jobStatusSimulacao;
    }

    @Generated
    public Long getJobIdDebito() {
        return this.jobIdDebito;
    }

    @Generated
    public BatchStatus getJobStatusDebito() {
        return this.jobStatusDebito;
    }

    @Generated
    public BatchStatus getJobStatusCarne() {
        return this.jobStatusCarne;
    }

    @Generated
    public BigDecimal getTotalCalculado() {
        return this.totalCalculado;
    }

    @Generated
    public BigDecimal getTotalIsencoes() {
        return this.totalIsencoes;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setTipo(TipoCalculo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setDataCalculo(LocalDate dataCalculo) {
        this.dataCalculo = dataCalculo;
    }

    @Generated
    public void setFiltroDivida(String filtroDivida) {
        this.filtroDivida = filtroDivida;
    }

    @Generated
    public void setFiltroCadastro(String filtroCadastro) {
        this.filtroCadastro = filtroCadastro;
    }

    @Generated
    public void setSituacao(SituacaoCalculo situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setTotalCadastros(Long totalCadastros) {
        this.totalCadastros = totalCadastros;
    }

    @Generated
    public void setTotalCadastrosComInconsistencia(Long totalCadastrosComInconsistencia) {
        this.totalCadastrosComInconsistencia = totalCadastrosComInconsistencia;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setDataGeracaoDebito(LocalDate dataGeracaoDebito) {
        this.dataGeracaoDebito = dataGeracaoDebito;
    }

    @Generated
    public void setUsuarioGeracaoDebito(String usuarioGeracaoDebito) {
        this.usuarioGeracaoDebito = usuarioGeracaoDebito;
    }

    @Generated
    public void setNecessitaConfigurarFormasPagamento(Boolean necessitaConfigurarFormasPagamento) {
        this.necessitaConfigurarFormasPagamento = necessitaConfigurarFormasPagamento;
    }

    @Generated
    public void setJobIdSimulacao(Long jobIdSimulacao) {
        this.jobIdSimulacao = jobIdSimulacao;
    }

    @Generated
    public void setJobStatusSimulacao(BatchStatus jobStatusSimulacao) {
        this.jobStatusSimulacao = jobStatusSimulacao;
    }

    @Generated
    public void setJobIdDebito(Long jobIdDebito) {
        this.jobIdDebito = jobIdDebito;
    }

    @Generated
    public void setJobStatusDebito(BatchStatus jobStatusDebito) {
        this.jobStatusDebito = jobStatusDebito;
    }

    @Generated
    public void setJobStatusCarne(BatchStatus jobStatusCarne) {
        this.jobStatusCarne = jobStatusCarne;
    }

    @Generated
    public void setTotalCalculado(BigDecimal totalCalculado) {
        this.totalCalculado = totalCalculado;
    }

    @Generated
    public void setTotalIsencoes(BigDecimal totalIsencoes) {
        this.totalIsencoes = totalIsencoes;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public String toString() {
        return "CalculoResumoDTO(id=" + this.getId() + ", exercicio=" + this.getExercicio() + ", usuario=" + this.getUsuario() + ", tipo=" + this.getTipo() + ", dataCalculo=" + this.getDataCalculo() + ", filtroDivida=" + this.getFiltroDivida() + ", filtroCadastro=" + this.getFiltroCadastro() + ", situacao=" + this.getSituacao() + ", totalCadastros=" + this.getTotalCadastros() + ", totalCadastrosComInconsistencia=" + this.getTotalCadastrosComInconsistencia() + ", dataCancelamento=" + this.getDataCancelamento() + ", usuarioCancelamento=" + this.getUsuarioCancelamento() + ", dataGeracaoDebito=" + this.getDataGeracaoDebito() + ", usuarioGeracaoDebito=" + this.getUsuarioGeracaoDebito() + ", necessitaConfigurarFormasPagamento=" + this.getNecessitaConfigurarFormasPagamento() + ", jobIdSimulacao=" + this.getJobIdSimulacao() + ", jobStatusSimulacao=" + this.getJobStatusSimulacao() + ", jobIdDebito=" + this.getJobIdDebito() + ", jobStatusDebito=" + this.getJobStatusDebito() + ", jobStatusCarne=" + this.getJobStatusCarne() + ", totalCalculado=" + this.getTotalCalculado() + ", totalIsencoes=" + this.getTotalIsencoes() + ", valorTotal=" + this.getValorTotal() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoResumoDTO)) {
            return false;
        }
        CalculoResumoDTO other = (CalculoResumoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoResumoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

