/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.domain.CalculoGeracaoLote;
import br.com.elotech.tributos.calculo.domain.CalculoGeracaoLoteFiltro;
import br.com.elotech.tributos.calculo.domain.Operador;
import br.com.elotech.tributos.calculo.dto.CampoDetalheDTO;
import br.com.elotech.tributos.domain.camposdinamicos.TipoCampo;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class CalculoGeracaoLoteFiltroDTO {
    private Long id;
    private Long idGeracaoLote;
    private CampoDetalheDTO campo;
    @Enumerated(value=EnumType.STRING)
    private Operador operador;
    private String valor;

    public CalculoGeracaoLoteFiltro toEntity(CalculoGeracaoLote calculoGeracaoLote) {
        CalculoGeracaoLoteFiltro filtro = new CalculoGeracaoLoteFiltro();
        filtro.setId(this.getId());
        filtro.setCalculoGeracaoLote(calculoGeracaoLote);
        filtro.setDescricao(this.getCampo().getDescricao());
        filtro.setTabela(this.getCampo().getTabela());
        filtro.setCampo(this.getCampo().getNome());
        filtro.setIdCampoDinamico(this.getCampo().getIdCampoDinamico());
        filtro.setTipoCampo(this.getCampo().getTipo());
        filtro.setOperador(this.getOperador());
        filtro.setValor(this.getValor());
        return filtro;
    }

    public static CalculoGeracaoLoteFiltroDTO of(CalculoGeracaoLoteFiltro filtro) {
        CalculoGeracaoLoteFiltroDTO filtroDTO = new CalculoGeracaoLoteFiltroDTO();
        filtroDTO.setId(filtro.getId());
        filtroDTO.setIdGeracaoLote(filtro.getCalculoGeracaoLote().getId());
        CampoDetalheDTO campoDetalheDTO = new CampoDetalheDTO();
        campoDetalheDTO.setTabela(filtro.getTabela());
        campoDetalheDTO.setNome(filtro.getCampo());
        campoDetalheDTO.setDescricao(filtro.getDescricao());
        campoDetalheDTO.setTipo(filtro.getTipoCampo());
        campoDetalheDTO.setIdCampoDinamico(filtro.getIdCampoDinamico());
        filtroDTO.setCampo(campoDetalheDTO);
        filtroDTO.setOperador(filtro.getOperador());
        filtroDTO.setValor(filtro.getValor());
        return filtroDTO;
    }

    public String generateFiltro() {
        StringBuilder filtro = new StringBuilder();
        filtro.append("(");
        if (Objects.nonNull(this.campo.getIdCampoDinamico())) {
            filtro.append(this.generateFiltroCampoTabelaDinamica());
        } else {
            filtro.append(this.generateFiltroCampoTabela());
        }
        filtro.append(")");
        return filtro.toString().toUpperCase();
    }

    private String generateFiltroCampoTabela() {
        return String.format("%s.%s %s %s", this.campo.getTabela(), this.campo.getNome(), this.operador.getSimbolo(), this.getValorFormatado());
    }

    private String getValorFormatado() {
        if (Operador.IS_NULL.equals((Object)this.operador) || Operador.IS_NOT_NULL.equals((Object)this.operador)) {
            return "";
        }
        if (Operador.IN.equals((Object)this.operador) || Operador.NOT_IN.equals((Object)this.operador)) {
            if (TipoCampo.TEXTO.equals((Object)this.campo.getTipo())) {
                String[] split = this.getValor().split(",", 999);
                String valores = Arrays.stream(split).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(String::trim).map(item -> "'" + item + "'").collect(Collectors.joining(","));
                return String.format("(%s)", valores);
            }
            return String.format("(%s)", this.getValor());
        }
        if (TipoCampo.TEXTO.equals((Object)this.campo.getTipo()) && Operador.CONTEM.equals((Object)this.operador)) {
            return "'%" + this.getValor() + "%'";
        }
        if (TipoCampo.TEXTO.equals((Object)this.campo.getTipo()) || TipoCampo.DATA.equals((Object)this.campo.getTipo()) || TipoCampo.BOOLEANO.equals((Object)this.campo.getTipo())) {
            return String.format("'%s'", this.getValor());
        }
        return this.getValor();
    }

    private String generateFiltroCampoTabelaDinamica() {
        return String.format("(%s) %s", this.campo.generateSelectCampoDinamico(), this.generateCondicaoWhere());
    }

    private String generateCondicaoWhere() {
        if (TipoCampo.INTEIRO.equals((Object)this.campo.getTipo()) || TipoCampo.MULTIPLA_ESCOLHA.equals((Object)this.campo.getTipo())) {
            return String.format("%s %s", this.operador.getSimbolo(), this.valor);
        }
        return String.format("%s '%s'", this.operador.getSimbolo(), this.getValor());
    }

    @Generated
    public CalculoGeracaoLoteFiltroDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdGeracaoLote() {
        return this.idGeracaoLote;
    }

    @Generated
    public CampoDetalheDTO getCampo() {
        return this.campo;
    }

    @Generated
    public Operador getOperador() {
        return this.operador;
    }

    @Generated
    public String getValor() {
        return this.valor;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdGeracaoLote(Long idGeracaoLote) {
        this.idGeracaoLote = idGeracaoLote;
    }

    @Generated
    public void setCampo(CampoDetalheDTO campo) {
        this.campo = campo;
    }

    @Generated
    public void setOperador(Operador operador) {
        this.operador = operador;
    }

    @Generated
    public void setValor(String valor) {
        this.valor = valor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoGeracaoLoteFiltroDTO)) {
            return false;
        }
        CalculoGeracaoLoteFiltroDTO other = (CalculoGeracaoLoteFiltroDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idGeracaoLote = this.getIdGeracaoLote();
        Long other$idGeracaoLote = other.getIdGeracaoLote();
        if (this$idGeracaoLote == null ? other$idGeracaoLote != null : !((Object)this$idGeracaoLote).equals(other$idGeracaoLote)) {
            return false;
        }
        CampoDetalheDTO this$campo = this.getCampo();
        CampoDetalheDTO other$campo = other.getCampo();
        if (this$campo == null ? other$campo != null : !this$campo.equals(other$campo)) {
            return false;
        }
        Operador this$operador = this.getOperador();
        Operador other$operador = other.getOperador();
        if (this$operador == null ? other$operador != null : !this$operador.equals(other$operador)) {
            return false;
        }
        String this$valor = this.getValor();
        String other$valor = other.getValor();
        return !(this$valor == null ? other$valor != null : !this$valor.equals(other$valor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoGeracaoLoteFiltroDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idGeracaoLote = this.getIdGeracaoLote();
        result = result * 59 + ($idGeracaoLote == null ? 43 : ((Object)$idGeracaoLote).hashCode());
        CampoDetalheDTO $campo = this.getCampo();
        result = result * 59 + ($campo == null ? 43 : $campo.hashCode());
        Operador $operador = this.getOperador();
        result = result * 59 + ($operador == null ? 43 : $operador.hashCode());
        String $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : $valor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoGeracaoLoteFiltroDTO(id=" + this.getId() + ", idGeracaoLote=" + this.getIdGeracaoLote() + ", campo=" + this.getCampo() + ", operador=" + this.getOperador() + ", valor=" + this.getValor() + ")";
    }
}

