/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.domain.CalculoGeracaoLote;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteAgrupamentoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteFiltroDTO;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteOrdenacaoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class CalculoGeracaoLoteDTO {
    private Long id;
    private Long idCalculo;
    @NotBlank
    @Size(max=400)
    private @NotBlank @Size(max=400) String descricao;
    private Long quantidadePorLote;
    private String usuario;
    private LocalDate dataGeracao;
    private List<CalculoGeracaoLoteFiltroDTO> filtros = new ArrayList();
    private List<CalculoGeracaoLoteAgrupamentoDTO> agrupamentos = new ArrayList();
    private List<CalculoGeracaoLoteOrdenacaoDTO> ordenacoes = new ArrayList();

    public CalculoGeracaoLote toEntity(Calculo calculo) {
        CalculoGeracaoLote calculoGeracaoLote = new CalculoGeracaoLote();
        calculoGeracaoLote.setId(this.getId());
        calculoGeracaoLote.setCalculo(calculo);
        calculoGeracaoLote.setDescricao(this.getDescricao());
        calculoGeracaoLote.setQuantidadePorLote(this.getQuantidadePorLote());
        if (StringUtils.isBlank((CharSequence)this.getUsuario())) {
            calculoGeracaoLote.setUsuario(SecurityUtils.getUserAise());
        } else {
            calculoGeracaoLote.setUsuario(this.getUsuario());
        }
        if (Objects.isNull(this.getDataGeracao())) {
            calculoGeracaoLote.setDataGeracao(LocalDate.now());
        } else {
            calculoGeracaoLote.setDataGeracao(this.getDataGeracao());
        }
        calculoGeracaoLote.getFiltros().addAll(this.filtros.stream().map(filtroDTO -> filtroDTO.toEntity(calculoGeracaoLote)).collect(Collectors.toList()));
        calculoGeracaoLote.getAgrupamentos().addAll(this.agrupamentos.stream().map(agrupamentoDTO -> agrupamentoDTO.toEntity(calculoGeracaoLote)).collect(Collectors.toList()));
        calculoGeracaoLote.getOrdenacao().addAll(this.ordenacoes.stream().map(ordenacaoDTO -> ordenacaoDTO.toEntity(calculoGeracaoLote)).collect(Collectors.toList()));
        return calculoGeracaoLote;
    }

    public static CalculoGeracaoLoteDTO of(CalculoGeracaoLote calculoGeracaoLote) {
        CalculoGeracaoLoteDTO dto = new CalculoGeracaoLoteDTO();
        dto.setId(calculoGeracaoLote.getId());
        dto.setIdCalculo(calculoGeracaoLote.getCalculo().getId());
        dto.setDescricao(calculoGeracaoLote.getDescricao());
        dto.setQuantidadePorLote(calculoGeracaoLote.getQuantidadePorLote());
        dto.setUsuario(calculoGeracaoLote.getUsuario());
        dto.setDataGeracao(calculoGeracaoLote.getDataGeracao());
        dto.getFiltros().addAll(calculoGeracaoLote.getFiltros().stream().map(CalculoGeracaoLoteFiltroDTO::of).collect(Collectors.toList()));
        dto.getAgrupamentos().addAll(calculoGeracaoLote.getAgrupamentos().stream().map(CalculoGeracaoLoteAgrupamentoDTO::of).collect(Collectors.toList()));
        dto.getOrdenacoes().addAll(calculoGeracaoLote.getOrdenacao().stream().map(CalculoGeracaoLoteOrdenacaoDTO::of).collect(Collectors.toList()));
        return dto;
    }

    @Generated
    public CalculoGeracaoLoteDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdCalculo() {
        return this.idCalculo;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Long getQuantidadePorLote() {
        return this.quantidadePorLote;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataGeracao() {
        return this.dataGeracao;
    }

    @Generated
    public List<CalculoGeracaoLoteFiltroDTO> getFiltros() {
        return this.filtros;
    }

    @Generated
    public List<CalculoGeracaoLoteAgrupamentoDTO> getAgrupamentos() {
        return this.agrupamentos;
    }

    @Generated
    public List<CalculoGeracaoLoteOrdenacaoDTO> getOrdenacoes() {
        return this.ordenacoes;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdCalculo(Long idCalculo) {
        this.idCalculo = idCalculo;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setQuantidadePorLote(Long quantidadePorLote) {
        this.quantidadePorLote = quantidadePorLote;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataGeracao(LocalDate dataGeracao) {
        this.dataGeracao = dataGeracao;
    }

    @Generated
    public void setFiltros(List<CalculoGeracaoLoteFiltroDTO> filtros) {
        this.filtros = filtros;
    }

    @Generated
    public void setAgrupamentos(List<CalculoGeracaoLoteAgrupamentoDTO> agrupamentos) {
        this.agrupamentos = agrupamentos;
    }

    @Generated
    public void setOrdenacoes(List<CalculoGeracaoLoteOrdenacaoDTO> ordenacoes) {
        this.ordenacoes = ordenacoes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoGeracaoLoteDTO)) {
            return false;
        }
        CalculoGeracaoLoteDTO other = (CalculoGeracaoLoteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idCalculo = this.getIdCalculo();
        Long other$idCalculo = other.getIdCalculo();
        if (this$idCalculo == null ? other$idCalculo != null : !((Object)this$idCalculo).equals(other$idCalculo)) {
            return false;
        }
        Long this$quantidadePorLote = this.getQuantidadePorLote();
        Long other$quantidadePorLote = other.getQuantidadePorLote();
        if (this$quantidadePorLote == null ? other$quantidadePorLote != null : !((Object)this$quantidadePorLote).equals(other$quantidadePorLote)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        LocalDate this$dataGeracao = this.getDataGeracao();
        LocalDate other$dataGeracao = other.getDataGeracao();
        if (this$dataGeracao == null ? other$dataGeracao != null : !((Object)this$dataGeracao).equals(other$dataGeracao)) {
            return false;
        }
        List this$filtros = this.getFiltros();
        List other$filtros = other.getFiltros();
        if (this$filtros == null ? other$filtros != null : !((Object)this$filtros).equals(other$filtros)) {
            return false;
        }
        List this$agrupamentos = this.getAgrupamentos();
        List other$agrupamentos = other.getAgrupamentos();
        if (this$agrupamentos == null ? other$agrupamentos != null : !((Object)this$agrupamentos).equals(other$agrupamentos)) {
            return false;
        }
        List this$ordenacoes = this.getOrdenacoes();
        List other$ordenacoes = other.getOrdenacoes();
        return !(this$ordenacoes == null ? other$ordenacoes != null : !((Object)this$ordenacoes).equals(other$ordenacoes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoGeracaoLoteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idCalculo = this.getIdCalculo();
        result = result * 59 + ($idCalculo == null ? 43 : ((Object)$idCalculo).hashCode());
        Long $quantidadePorLote = this.getQuantidadePorLote();
        result = result * 59 + ($quantidadePorLote == null ? 43 : ((Object)$quantidadePorLote).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        LocalDate $dataGeracao = this.getDataGeracao();
        result = result * 59 + ($dataGeracao == null ? 43 : ((Object)$dataGeracao).hashCode());
        List $filtros = this.getFiltros();
        result = result * 59 + ($filtros == null ? 43 : ((Object)$filtros).hashCode());
        List $agrupamentos = this.getAgrupamentos();
        result = result * 59 + ($agrupamentos == null ? 43 : ((Object)$agrupamentos).hashCode());
        List $ordenacoes = this.getOrdenacoes();
        result = result * 59 + ($ordenacoes == null ? 43 : ((Object)$ordenacoes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoGeracaoLoteDTO(id=" + this.getId() + ", idCalculo=" + this.getIdCalculo() + ", descricao=" + this.getDescricao() + ", quantidadePorLote=" + this.getQuantidadePorLote() + ", usuario=" + this.getUsuario() + ", dataGeracao=" + this.getDataGeracao() + ", filtros=" + this.getFiltros() + ", agrupamentos=" + this.getAgrupamentos() + ", ordenacoes=" + this.getOrdenacoes() + ")";
    }
}

