/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.core.exception.EloValidationException;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ArquivoGraficaTributoDTO {
    private String codigoTributo;
    private BigDecimal valorTributo;
    private String descricaoTributo;
    private String apelidoTributo;
    private static final int QUANTIDADE_ATRIBUTOS = 4;

    public static List<ArquivoGraficaTributoDTO> stringToList(String stringTributos) {
        String[] tributos = stringTributos.split("###");
        return Stream.of(tributos).map(tributo -> {
            String[] informacoesTributo = tributo.split("##");
            if (informacoesTributo.length != 4) {
                throw new EloValidationException(String.format("Problema ao buscar informa\u00e7\u00f5es dos tributos do carn\u00ea. Tributo:%s", tributo));
            }
            ArquivoGraficaTributoDTO tributoDTO = new ArquivoGraficaTributoDTO();
            tributoDTO.setCodigoTributo(informacoesTributo[0]);
            tributoDTO.setValorTributo(new BigDecimal(informacoesTributo[1]));
            tributoDTO.setDescricaoTributo(informacoesTributo[2]);
            tributoDTO.setApelidoTributo(informacoesTributo[3]);
            return tributoDTO;
        }).collect(Collectors.toList());
    }

    @Generated
    public ArquivoGraficaTributoDTO() {
    }

    @Generated
    public String getCodigoTributo() {
        return this.codigoTributo;
    }

    @Generated
    public BigDecimal getValorTributo() {
        return this.valorTributo;
    }

    @Generated
    public String getDescricaoTributo() {
        return this.descricaoTributo;
    }

    @Generated
    public String getApelidoTributo() {
        return this.apelidoTributo;
    }

    @Generated
    public void setCodigoTributo(String codigoTributo) {
        this.codigoTributo = codigoTributo;
    }

    @Generated
    public void setValorTributo(BigDecimal valorTributo) {
        this.valorTributo = valorTributo;
    }

    @Generated
    public void setDescricaoTributo(String descricaoTributo) {
        this.descricaoTributo = descricaoTributo;
    }

    @Generated
    public void setApelidoTributo(String apelidoTributo) {
        this.apelidoTributo = apelidoTributo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArquivoGraficaTributoDTO)) {
            return false;
        }
        ArquivoGraficaTributoDTO other = (ArquivoGraficaTributoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$codigoTributo = this.getCodigoTributo();
        String other$codigoTributo = other.getCodigoTributo();
        if (this$codigoTributo == null ? other$codigoTributo != null : !this$codigoTributo.equals(other$codigoTributo)) {
            return false;
        }
        BigDecimal this$valorTributo = this.getValorTributo();
        BigDecimal other$valorTributo = other.getValorTributo();
        if (this$valorTributo == null ? other$valorTributo != null : !((Object)this$valorTributo).equals(other$valorTributo)) {
            return false;
        }
        String this$descricaoTributo = this.getDescricaoTributo();
        String other$descricaoTributo = other.getDescricaoTributo();
        if (this$descricaoTributo == null ? other$descricaoTributo != null : !this$descricaoTributo.equals(other$descricaoTributo)) {
            return false;
        }
        String this$apelidoTributo = this.getApelidoTributo();
        String other$apelidoTributo = other.getApelidoTributo();
        return !(this$apelidoTributo == null ? other$apelidoTributo != null : !this$apelidoTributo.equals(other$apelidoTributo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArquivoGraficaTributoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $codigoTributo = this.getCodigoTributo();
        result = result * 59 + ($codigoTributo == null ? 43 : $codigoTributo.hashCode());
        BigDecimal $valorTributo = this.getValorTributo();
        result = result * 59 + ($valorTributo == null ? 43 : ((Object)$valorTributo).hashCode());
        String $descricaoTributo = this.getDescricaoTributo();
        result = result * 59 + ($descricaoTributo == null ? 43 : $descricaoTributo.hashCode());
        String $apelidoTributo = this.getApelidoTributo();
        result = result * 59 + ($apelidoTributo == null ? 43 : $apelidoTributo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArquivoGraficaTributoDTO(codigoTributo=" + this.getCodigoTributo() + ", valorTributo=" + this.getValorTributo() + ", descricaoTributo=" + this.getDescricaoTributo() + ", apelidoTributo=" + this.getApelidoTributo() + ")";
    }
}

