/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.solicitacao.processamento;

import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.enums.supersimples.TipoOperacaoSuperSimplesSolicitacao;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JpaPagingItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ProcessamentoVarreduraSuperSimplesReader
extends JpaPagingItemReader<SuperSimplesSolicitacaoCnpj> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoVarreduraSuperSimplesReader.class);

    public ProcessamentoVarreduraSuperSimplesReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, EntityManagerFactory entityManagerFactory) {
        Long idSolicitacao = (Long)jobParameters.get("idSolicitacao");
        String tipoOperacao = (String)jobParameters.get("tipoOperacao");
        this.setPageSize(500);
        this.setName("verificacaoSuperSimplesId");
        this.setEntityManagerFactory(entityManagerFactory);
        this.setQueryString(this.getItensSql(tipoOperacao));
        this.setParameterValues(Collections.singletonMap("idSolicitacao", idSolicitacao));
    }

    private String getItensSql(String tipoOperacao) {
        if (TipoOperacaoSuperSimplesSolicitacao.INICIAL.getDescricao().equals(tipoOperacao)) {
            return " SELECT c  FROM SuperSimplesSolicitacaoCnpj c  WHERE c.id.solicitacao.id = :idSolicitacao ORDER BY c.id.sequencia ";
        }
        if (TipoOperacaoSuperSimplesSolicitacao.COMPLEMENTAR.getDescricao().equals(tipoOperacao)) {
            return " SELECT c  FROM SuperSimplesSolicitacaoCnpj c  WHERE NOT EXISTS ( SELECT 1                     FROM SuperSimplesSolicitacaoVedados v                     WHERE v.id.solicitacao.id = c.id.solicitacao.id                      AND v.id.sequencia = c.id.sequencia                      AND v.cnpj = c.cnpj )  AND c.id.solicitacao.id = :idSolicitacao ORDER BY c.id.sequencia ";
        }
        return " SELECT c  FROM SuperSimplesSolicitacaoCnpj c  INNER JOIN SuperSimplesSolicitacaoVedados v ON v.id.solicitacao.id = c.id.solicitacao.id                                             AND v.id.sequencia = c.id.sequencia                                             AND v.cnpj = c.cnpj  WHERE c.id.solicitacao.id = :idSolicitacao ORDER BY c.id.sequencia ";
    }
}

