/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.solicitacao.processamento;

import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoSituacao;
import br.com.elotech.tributos.enums.supersimples.TipoOperacaoSuperSimplesSolicitacao;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoSituacaoRepository;
import br.com.elotech.tributos.service.supersimples.ProcessamentoSuperSimplesService;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ProcessamentoVarreduraSuperSimplesProcessor
implements ItemProcessor<SuperSimplesSolicitacaoCnpj, SuperSimplesSolicitacaoSituacao> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoVarreduraSuperSimplesProcessor.class);
    private final ProcessamentoSuperSimplesService processamentoSuperSimplesService;
    private final SuperSimplesSolicitacaoSituacaoRepository superSimplesSolicitacaoSituacaoRepository;
    private StepExecution stepExecution;
    private AtomicLong currentSequence;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.currentSequence = new AtomicLong(this.getLastSequenceNumber());
    }

    public SuperSimplesSolicitacaoSituacao process(SuperSimplesSolicitacaoCnpj item) {
        Long idSolicitacao = this.stepExecution.getJobExecution().getJobParameters().getLong("idSolicitacao");
        Long sequenciaVarredura = this.stepExecution.getJobExecution().getJobParameters().getLong("sequenciaVarredura");
        String tipoOperacao = this.stepExecution.getJobExecution().getJobParameters().getString("tipoOperacao");
        long sequencia = this.currentSequence.incrementAndGet();
        return this.processamentoSuperSimplesService.processarVarreduraBatch(item, idSolicitacao, sequenciaVarredura.longValue(), sequencia, TipoOperacaoSuperSimplesSolicitacao.fromDescricao((String)tipoOperacao));
    }

    private long getLastSequenceNumber() {
        Long idSolicitacao = this.stepExecution.getJobExecution().getJobParameters().getLong("idSolicitacao");
        Long sequenciaVarredura = this.stepExecution.getJobExecution().getJobParameters().getLong("sequenciaVarredura");
        return this.superSimplesSolicitacaoSituacaoRepository.findMaxSequenciaBySolicitacaoIdAndSequenciaVarredura(idSolicitacao, sequenciaVarredura);
    }

    @Generated
    public ProcessamentoVarreduraSuperSimplesProcessor(ProcessamentoSuperSimplesService processamentoSuperSimplesService, SuperSimplesSolicitacaoSituacaoRepository superSimplesSolicitacaoSituacaoRepository) {
        this.processamentoSuperSimplesService = processamentoSuperSimplesService;
        this.superSimplesSolicitacaoSituacaoRepository = superSimplesSolicitacaoSituacaoRepository;
    }
}

