/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.solicitacao.importacao;

import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnae;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnaeId;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.repository.CnaeRepository;
import br.com.elotech.tributos.service.resolvers.arquivoclient.ArquivoClientMinioResolver;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.InputStream;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.FixedLengthTokenizer;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@StepScope
public class ImportacaoSuperSimplesReader
extends FlatFileItemReader<SuperSimplesSolicitacaoCnpj> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoSuperSimplesReader.class);
    private CnaeRepository cnaeRepository;
    private static final int MAX_CNAE = 11;

    public ImportacaoSuperSimplesReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, ArquivoStorageFeignClient arquivoStorageFeignClient, ArquivoClientMinioResolver arquivoClientMinioResolver, CnaeRepository cnaeRepository) {
        this.cnaeRepository = cnaeRepository;
        Long idArquivo = (Long)jobParameters.get("idArquivo");
        this.setResource((Resource)new InputStreamResource(this.getFileStream(idArquivo, arquivoClientMinioResolver, arquivoStorageFeignClient)));
        this.setLineMapper((LineMapper)this.buildLineMapper());
    }

    private InputStream getFileStream(Long idArquivo, ArquivoClientMinioResolver minioResolver, ArquivoStorageFeignClient feignClient) {
        ArquivoDTO arquivoDto = feignClient.findOne(idArquivo);
        log.debug("Buscando url de download do arquivo");
        ArquivoFindRequest arquivoFindRequest = ArquivoFindRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getTenantId().orElse("")), (String)arquivoDto.getFullPath());
        return minioResolver.getArquivoClient().buscarArquivo(arquivoFindRequest).map(ArquivoContent::getContent).orElseThrow(() -> new EloValidationException("Erro ao baixar o arquivo"));
    }

    private DefaultLineMapper<SuperSimplesSolicitacaoCnpj> buildLineMapper() {
        DefaultLineMapper lineMapper = new DefaultLineMapper();
        lineMapper.setLineTokenizer((LineTokenizer)ImportacaoSuperSimplesReader.createLineTokenizer());
        lineMapper.setFieldSetMapper(fieldSet -> {
            SuperSimplesSolicitacaoCnpj solicitacaoCnpj = new SuperSimplesSolicitacaoCnpj();
            solicitacaoCnpj.setCnpj(fieldSet.readString("cnpj"));
            for (int i = 1; i <= 11; ++i) {
                this.processCnaeField(fieldSet, solicitacaoCnpj, i);
            }
            return solicitacaoCnpj;
        });
        return lineMapper;
    }

    private static FixedLengthTokenizer createLineTokenizer() {
        FixedLengthTokenizer fixedLengthTokenizer = new FixedLengthTokenizer();
        fixedLengthTokenizer.setNames(new String[]{"cnpj", "codigoMunicipio", "cnae1", "cnae2", "cnae3", "cnae4", "cnae5", "cnae6", "cnae7", "cnae8", "cnae9", "cnae10", "cnae11"});
        fixedLengthTokenizer.setColumns(new Range[]{new Range(1, 14), new Range(15, 18), new Range(19, 25), new Range(26, 32), new Range(33, 39), new Range(40, 46), new Range(47, 53), new Range(54, 60), new Range(61, 67), new Range(68, 74), new Range(75, 81), new Range(82, 88), new Range(89, 95)});
        fixedLengthTokenizer.setStrict(Boolean.FALSE.booleanValue());
        return fixedLengthTokenizer;
    }

    private void processCnaeField(FieldSet fieldSet, SuperSimplesSolicitacaoCnpj solicitacaoCnpj, int index) {
        String cnaeCodeString = fieldSet.readString("cnae" + index);
        if (this.isCnaeValidAndExists(cnaeCodeString)) {
            Long cnaeCodigo = Long.parseLong(cnaeCodeString);
            SuperSimplesSolicitacaoCnae solicitacaoCnae = this.createSolicitacaoCnae(solicitacaoCnpj, cnaeCodigo, index == 1);
            solicitacaoCnpj.getCnaes().add(solicitacaoCnae);
        }
    }

    private boolean isCnaeValidAndExists(String cnaeCodeString) {
        if (cnaeCodeString == null || cnaeCodeString.trim().isEmpty()) {
            return false;
        }
        try {
            long cnaeCodigo = Long.parseLong(cnaeCodeString);
            if (cnaeCodigo > 0L && this.cnaeRepository.existsById((Object)cnaeCodigo)) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            log.warn("CNAE c\u00f3digo inv\u00e1lido: {}", (Object)cnaeCodeString, (Object)e);
        }
        return false;
    }

    private SuperSimplesSolicitacaoCnae createSolicitacaoCnae(SuperSimplesSolicitacaoCnpj solicitacaoCnpj, Long cnaeCodigo, boolean isPrincipal) {
        SuperSimplesSolicitacaoCnaeId cnaeId = new SuperSimplesSolicitacaoCnaeId();
        cnaeId.setCnae(cnaeCodigo);
        SuperSimplesSolicitacaoCnae solicitacaoCnae = new SuperSimplesSolicitacaoCnae();
        solicitacaoCnae.setCnaePrincipal(Boolean.valueOf(isPrincipal));
        solicitacaoCnae.setId(cnaeId);
        solicitacaoCnae.setSolicitacaoCnpj(solicitacaoCnpj);
        return solicitacaoCnae;
    }
}

