/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.dassenda.importacao;

import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.batch.supersimples.dassenda.importacao.ImportacaoArquivoDassendaReader;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoAberturaDTO;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoCalculoDTO;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoCalculoItemDTO;
import br.com.elotech.tributos.dto.supersimples.dassenda.DassendaArquivoItemDTO;
import br.com.elotech.tributos.enums.supersimples.dassenda.SituacaoCalculoArquivoDassenda;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.resolvers.arquivoclient.ArquivoClientMinioResolver;
import br.com.elotech.tributos.util.FileUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImportacaoArquivoDassendaReader
extends FlatFileItemReader<DassendaArquivoItemDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoDassendaReader.class);
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final String DATE_TIME_FORMAT = "yyyyMMddHHmmss";
    private static final List<String> IDS_SISTEMAS_ORIGEM_PERMITIDOS = List.of("0013", "0021", "0024", "0025", "0029", "0030");
    private DassendaArquivoItemDTO itemAgrupado;
    private final Long codigoTomMunicipio;
    private final Map<String, RegistroProcessor> processors = Map.of("AAAAA", arg_0 -> this.processRegistroAbertura(arg_0), "01000", arg_0 -> this.processRegistroCalculo(arg_0), "01100", arg_0 -> this.processRegistroCalculoItem(arg_0), "99999", arg_0 -> this.processRegistroCalculoRodape(arg_0), "ZZZZZ", fieldSet -> null);

    public ImportacaoArquivoDassendaReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, ArquivoStorageFeignClient arquivoStorageFeignClient, ArquivoClientMinioResolver arquivoClientMinioResolver, ParametroGeralService parametroGeralService) {
        this.codigoTomMunicipio = parametroGeralService.getParamValueAsLong(ParametroGeralEnum.CODIGO_TOM_MUNICIPIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Long idArquivo = (Long)jobParameters.get("idArquivo");
        this.setResource((Resource)new InputStreamResource(this.getFileStream(idArquivo, arquivoClientMinioResolver, arquivoStorageFeignClient)));
        this.setLineMapper(this.buildLineMapper());
    }

    private InputStream getFileStream(Long idArquivo, ArquivoClientMinioResolver minioResolver, ArquivoStorageFeignClient feignClient) {
        ArquivoDTO arquivoDto = feignClient.findOne(idArquivo);
        log.debug("Buscando url de download do arquivo");
        ArquivoFindRequest request = ArquivoFindRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getTenantId().orElse("")), (String)arquivoDto.getFullPath());
        return minioResolver.getArquivoClient().buscarArquivo(request).map(ArquivoContent::getContent).orElseThrow(() -> new EloValidationException("Erro ao baixar o arquivo"));
    }

    private LineMapper<DassendaArquivoItemDTO> buildLineMapper() {
        DefaultLineMapper lineMapper = new DefaultLineMapper();
        lineMapper.setLineTokenizer((LineTokenizer)this.createLineTokenizer());
        lineMapper.setFieldSetMapper(arg_0 -> this.mapLineToDTO(arg_0));
        return lineMapper;
    }

    private DelimitedLineTokenizer createLineTokenizer() {
        DelimitedLineTokenizer tokenizer = new DelimitedLineTokenizer("|");
        tokenizer.setStrict(Boolean.FALSE.booleanValue());
        return tokenizer;
    }

    private DassendaArquivoItemDTO mapLineToDTO(FieldSet fieldSet) {
        return this.processors.getOrDefault(fieldSet.readString(0), fs -> {
            throw new IllegalArgumentException("Tipo de linha desconhecido: " + fs.readString(0));
        }).process(fieldSet);
    }

    private DassendaArquivoItemDTO processRegistroAbertura(FieldSet fieldSet) {
        DassendaArquivoItemDTO dto = new DassendaArquivoItemDTO();
        dto.setAbertura(this.buildAberturaDTO(fieldSet));
        return dto;
    }

    private DassendaArquivoItemDTO processRegistroCalculo(FieldSet fieldSet) {
        String idSistemaOrigem = fieldSet.readString(3);
        if (IDS_SISTEMAS_ORIGEM_PERMITIDOS.contains(idSistemaOrigem)) {
            this.itemAgrupado = new DassendaArquivoItemDTO();
            this.itemAgrupado.setCalculo(this.buildCalculoDTO(fieldSet));
            this.itemAgrupado.setCalculoItens(new ArrayList());
        }
        return new DassendaArquivoItemDTO();
    }

    private DassendaArquivoItemDTO processRegistroCalculoItem(FieldSet fieldSet) {
        Long codigoTomItem = FileUtils.tryParseLongOrNull((String)fieldSet.readString(9));
        if (this.itemAgrupado != null && this.codigoTomMunicipio != null && this.codigoTomMunicipio.equals(codigoTomItem)) {
            this.itemAgrupado.getCalculoItens().add(this.buildCalculoItemDTO(fieldSet));
        }
        return new DassendaArquivoItemDTO();
    }

    private DassendaArquivoItemDTO processRegistroCalculoRodape(FieldSet fieldSet) {
        DassendaArquivoItemDTO itemDTO = this.itemAgrupado;
        this.itemAgrupado = null;
        return itemDTO != null ? itemDTO : new DassendaArquivoItemDTO();
    }

    private DassendaArquivoAberturaDTO buildAberturaDTO(FieldSet fieldSet) {
        return DassendaArquivoAberturaDTO.builder().registro(fieldSet.readString(0)).versao(FileUtils.tryParseLongOrNull((String)fieldSet.readString(1))).dataInicial(FileUtils.tryParseLocalDateOrNull((String)fieldSet.readString(2), (String)DATE_FORMAT)).dataFinal(FileUtils.tryParseLocalDateOrNull((String)fieldSet.readString(3), (String)DATE_FORMAT)).build();
    }

    private DassendaArquivoCalculoDTO buildCalculoDTO(FieldSet fieldSet) {
        return DassendaArquivoCalculoDTO.builder().registro(FileUtils.tryParseLongOrNull((String)fieldSet.readString(0))).dataGeracao(FileUtils.tryParseLocalDateTimeOrNull((String)fieldSet.readString(1), (String)DATE_TIME_FORMAT)).numeroGuia(FileUtils.tryParseLongOrNull((String)fieldSet.readString(2))).idSistemaOrigem(FileUtils.tryParseLongOrNull((String)fieldSet.readString(3))).cnpjMatriz(fieldSet.readString(4)).valorPrincipal(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(5))).valorMulta(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(6))).valorJuros(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(7))).valorEncargoLegal(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(8))).dataVencimento(FileUtils.tryParseLocalDateOrNull((String)fieldSet.readString(9), (String)DATE_FORMAT)).dataValidade(FileUtils.tryParseLocalDateOrNull((String)fieldSet.readString(10), (String)DATE_FORMAT)).valorTotal(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(11))).cpf(FileUtils.tryParseLongOrNull((String)fieldSet.readString(12))).situacao(SituacaoCalculoArquivoDassenda.IMPORTADO).build();
    }

    private DassendaArquivoCalculoItemDTO buildCalculoItemDTO(FieldSet fieldSet) {
        return DassendaArquivoCalculoItemDTO.builder().registro(fieldSet.readString(0)).periodoApuracao(FileUtils.tryParseLongOrNull((String)fieldSet.readString(1))).codigoReceitaPrincipal(fieldSet.readString(2)).valorPrincipal(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(3))).codigoReceitaMulta(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(4))).valorMulta(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(5))).codigoReceitaJuros(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(6))).valorJuros(FileUtils.tryParseBigDecimalOrNull((String)fieldSet.readString(7))).unidadeFederativa(fieldSet.readString(8)).codigoMunicipio(FileUtils.tryParseLongOrNull((String)fieldSet.readString(9))).build();
    }
}

