/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class LancamentoCreditoImplantacaoSaldoJobListener
extends JobExecutionListenerSupport {
    private static final String EXERCICIO = "exercicio";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        Optional notificacaoId = this.notificacaoService.send(String.format("Foi iniciada a gera\u00e7\u00e3o de dados de Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) - %d", exercicio), "SIM-AM - Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) iniciado", jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send(String.format("Os dados referentes ao Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) -> %d, foram gerados com sucesso.", exercicio), "SIM-AM - Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo) finalizado com sucesso", jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("N\u00e3o foi poss\u00edvel gerar os dados.", "Erro na gera\u00e7\u00e3o de dados do SIM-AM - Lan\u00e7amento de Cr\u00e9dito (Implanta\u00e7\u00e3o de Saldo)", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public LancamentoCreditoImplantacaoSaldoJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

