/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoConsultaDTO;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LancamentoCreditoImplantacaoSaldoBatchReader
extends JdbcCursorItemReader<LancamentoCreditoConsultaDTO> {
    public LancamentoCreditoImplantacaoSaldoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) throws Exception {
        Long entidade = (Long)jobParameters.get("entidade");
        Long exercicio = (Long)jobParameters.get("exercicio");
        Long idControle = (Long)jobParameters.get("idControle");
        this.setFetchSize(10000);
        this.setName("simamLancamentoCreditoImplantacaoSaldoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(LancamentoCreditoConsultaDTO.class));
        String sqlBase = FileUtils.readResourceAsString((String)"sql/simam/lancamentoCreditoImplantacaoSaldoBatch.sql");
        String sqlComParametros = sqlBase.replace(":exercicio", exercicio.toString()).replace(":idcontrole", idControle.toString()).replace(":entidade", entidade.toString());
        this.setSql(sqlComParametros);
    }
}

