/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LancamentoCreditoBatchReader
extends JdbcCursorItemReader<LancamentoCreditoConsultaDTO> {
    public LancamentoCreditoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) throws Exception {
        Long entidade = (Long)jobParameters.get("entidade");
        Long exercicio = (Long)jobParameters.get("exercicio");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataFinal")));
        this.setFetchSize(10000);
        this.setName("simamLancamentoCreditoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(LancamentoCreditoConsultaDTO.class));
        String sqlBase = FileUtils.readResourceAsString((String)"sql/simam/lancamentoCreditoBatch.sql");
        String sqlComParametros = sqlBase.replace(":dataInicial", StringUtils.wrap((String)dataInicial.toString(), (String)"'")).replace(":dataFinal", StringUtils.wrap((String)dataFinal.toString(), (String)"'")).replace(":entidade", entidade.toString()).replace(":exercicio", exercicio.toString());
        this.setSql(sqlComParametros);
    }
}

