/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.lancamentocredito;

import br.com.elotech.tributos.batch.simam.ReferenciaOrigemParcelamentoService;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCredito;
import br.com.elotech.tributos.domain.simam.LancamentoCredito;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributoId;
import br.com.elotech.tributos.domain.simam.RestituicaoLancamentoCredito;
import br.com.elotech.tributos.domain.simam.RestituicaoLancamentoCreditoTributoId;
import br.com.elotech.tributos.domain.simam.RetencaoLancamentoCredito;
import br.com.elotech.tributos.domain.simam.TipoLancamentoCredito;
import br.com.elotech.tributos.dto.ClassificacaoTipoTributo;
import br.com.elotech.tributos.dto.TipoNaturezaCredito;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import br.com.elotech.tributos.dto.simam.LancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.LancamentoCreditoRepository;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.MudancaMonetariaService;
import br.com.elotech.tributos.service.RetencaoContabilService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LancamentoCreditoBatchProcessor
implements ItemProcessor<LancamentoCreditoConsultaDTO, TipoLancamentoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LancamentoCreditoBatchProcessor.class);
    private Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private Map<Long, FormaCorrecao> formasDeCorrecao = new ConcurrentHashMap();
    private Map<Long, FormaCorrecao> outrasFormasDeCorrecao = new ConcurrentHashMap();
    private List<MudancaMonetaria> mudancasMonetarias = new ArrayList();
    private AtomicLong ultimoNrCredito = new AtomicLong(0L);
    private Long nrAnoCredito;
    private LocalDate dataReferencia = null;
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final LancamentoCreditoRepository lancamentoCreditoRepository;
    private final FormaCorrecaoService formaCorrecaoService;
    private final MudancaMonetariaService mudancaMonetariaService;
    private final ReferenciaOrigemParcelamentoService referenciaOrigemParcelamentoService;
    private final RetencaoContabilService retencaoContabilService;
    private final ObjectMapper objectMapper;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info("SIM-AM - Lan\u00e7amento Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados");
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        LOGGER.info("SIM-AM - Lan\u00e7amento Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {} ", (Object)dataInicial, (Object)dataFinal);
        this.dataReferencia = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataReferencia")));
        this.nrAnoCredito = dataInicial.getYear();
        LOGGER.info("SIM-AM - Realizando consulta das reten\u00e7oes cont\u00e1beis");
        this.retencaoContabilService.findAndSaveRetencoesPeriodo(entidade, Long.valueOf(dataInicial.getYear()), Long.valueOf(dataInicial.getMonth().getValue()));
        LOGGER.info("SIM-AM - Lan\u00e7amento Cr\u00e9dito - criando lista das formas de corre\u00e7\u00f5es existentes");
        this.formaCorrecaoService.findAll(Pageable.unpaged()).getContent().stream().map(FormaCorrecao::getId).forEach(idFormaCorrecao -> this.formasDeCorrecao.put(idFormaCorrecao, this.formaCorrecaoService.findOne(idFormaCorrecao)));
        LOGGER.info("SIM-AM - Lan\u00e7amento Cr\u00e9dito - load da carga existente");
        this.lancamentoCreditoRepository.getCargaExistenteLancamentoCredito(entidade, dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getId()));
        LOGGER.info("SIM-AM - Lan\u00e7amento Cr\u00e9dito - atualizando \u00faltimo NrCredito");
        this.ultimoNrCredito.set(this.lancamentoCreditoRepository.findNextNrCreditoByExercicio(Long.valueOf(dataInicial.getYear())));
        this.mudancasMonetarias = this.mudancaMonetariaService.findByRsql(Optional.empty());
    }

    public TipoLancamentoCredito process(LancamentoCreditoConsultaDTO item) {
        String chave = String.format("%d-%d-%d-%d-%s", item.getIdTipoNaturezaCredito(), item.getIdTipoCredito(), item.getIdTipoOperacaoCredito(), item.getCdControleLeiAto(), item.getDtLancamento().toString());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextVal = this.sequenceGeneratorRepository.getNextVal("S05IDTCELANCCREDITO");
            LancamentoCredito lancamentoCredito = new LancamentoCredito();
            lancamentoCredito.setId(nextVal);
            lancamentoCredito.setTipoNaturezaCredito(TipoNaturezaCredito.fromValue((Long)item.getIdTipoNaturezaCredito()));
            lancamentoCredito.setTipoCredito(ClassificacaoTipoTributo.fromValue((Integer)item.getIdTipoCredito().intValue()));
            lancamentoCredito.setTipoOperacaoCredito(TipoOperacaoCredito.fromValue((Long)item.getIdTipoOperacaoCredito()));
            lancamentoCredito.setDataLancamento(item.getDtLancamento());
            lancamentoCredito.setNrAnoCredito(this.nrAnoCredito);
            lancamentoCredito.setNrCredito(Long.valueOf(this.ultimoNrCredito.getAndIncrement()));
            lancamentoCredito.setNrAnoBase(Long.valueOf(item.getDtLancamento().getYear()));
            lancamentoCredito.setNrMesBase(Long.valueOf(item.getDtLancamento().getMonth().getValue()));
            lancamentoCredito.setCdControleLeiAto(item.getCdControleLeiAto());
            LOGGER.info("SIM-AM - Lan\u00e7amento Cr\u00e9dito - gerando novo registro -> {} ({}/{})", new Object[]{nextVal, lancamentoCredito.getNrCredito(), lancamentoCredito.getNrAnoCredito()});
            this.lancamentoCreditoRepository.save((Object)lancamentoCredito);
            this.entityManager.flush();
            return nextVal;
        });
        if (item.getIdRetencaoContabil() > 0L) {
            RetencaoLancamentoCredito retencaoLancCredito = new RetencaoLancamentoCredito();
            retencaoLancCredito.setId(item.getIdRetencaoContabil());
            retencaoLancCredito.setIdTceLancCredito(finalId);
            return retencaoLancCredito;
        }
        FormaCorrecao formaCorrecao = null;
        formaCorrecao = Objects.nonNull(item.getFormaCorrecao()) ? (FormaCorrecao)this.formasDeCorrecao.get(item.getFormaCorrecao()) : Optional.ofNullable((FormaCorrecao)this.outrasFormasDeCorrecao.get(item.getIdDivida())).orElseGet(() -> {
            FormaCorrecao fc = this.formaCorrecaoService.getFormaCorrecaoPadrao(item.getIdDivida(), item.getEntidade(), item.getExercicio());
            this.outrasFormasDeCorrecao.put(item.getIdDivida(), fc);
            return fc;
        });
        if (TipoOperacaoCredito.fromValue((Long)item.getIdTipoOperacaoCredito()).equals((Object)TipoOperacaoCredito.CREDITOS_A_RESTITUIR)) {
            RestituicaoLancamentoCreditoTributoId id = new RestituicaoLancamentoCreditoTributoId();
            id.setLancamentoCredito((LancamentoCredito)this.entityManager.getReference(LancamentoCredito.class, (Object)finalId));
            id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
            id.setDevolucaoCredito((DevolucaoCredito)this.entityManager.getReference(DevolucaoCredito.class, (Object)item.getIdDevolucaoCredito()));
            RestituicaoLancamentoCredito restituicaoLancamentoCredito = new RestituicaoLancamentoCredito();
            restituicaoLancamentoCredito.setId(id);
            restituicaoLancamentoCredito.setAnoGerado(Long.valueOf(item.getDtLancamento().getYear()));
            restituicaoLancamentoCredito.setMesGerado(Long.valueOf(item.getDtLancamento().getMonth().getValue()));
            restituicaoLancamentoCredito.setValor(CalculoCorrecaoUtils.converteMoedaOuAplicaMudanca((BigDecimal)item.getVlLancamento(), (LocalDate)item.getDtLancamento(), (LocalDate)this.dataReferencia, (FormaCorrecao)formaCorrecao, (List)this.mudancasMonetarias));
            return restituicaoLancamentoCredito;
        }
        LancamentoCreditoTributoId id = new LancamentoCreditoTributoId();
        id.setLancamentoCredito((LancamentoCredito)this.entityManager.getReference(LancamentoCredito.class, (Object)finalId));
        id.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
        LancamentoCreditoTributo lancamentoTributo = new LancamentoCreditoTributo();
        lancamentoTributo.setId(id);
        lancamentoTributo.setAnoGerado(Long.valueOf(item.getDtLancamento().getYear()));
        lancamentoTributo.setMesGerado(Long.valueOf(item.getDtLancamento().getMonth().getValue()));
        lancamentoTributo.setValor(CalculoCorrecaoUtils.converteMoedaOuAplicaMudanca((BigDecimal)item.getVlLancamento(), (LocalDate)item.getDtLancamento(), (LocalDate)this.dataReferencia, (FormaCorrecao)formaCorrecao, (List)this.mudancasMonetarias));
        return lancamentoTributo;
    }

    @OnProcessError
    public void onProcessError(LancamentoCreditoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error("SIM-AM - Lan\u00e7amento Cr\u00e9dito - erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }

    @AfterStep
    public ExitStatus onAfterStep(StepExecution stepExecution) {
        try {
            this.referenciaOrigemParcelamentoService.atualizaReferenciaExercicio(stepExecution.getJobExecution());
            return stepExecution.getExitStatus();
        }
        catch (Exception ex) {
            LOGGER.error("SIM-AM - Lan\u00e7amento Cr\u00e9dito - Erro ao atualizar a referencia origem parcelamento", (Throwable)ex);
            return ExitStatus.FAILED.addExitDescription((Throwable)ex);
        }
    }

    @Generated
    public LancamentoCreditoBatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, LancamentoCreditoRepository lancamentoCreditoRepository, FormaCorrecaoService formaCorrecaoService, MudancaMonetariaService mudancaMonetariaService, ReferenciaOrigemParcelamentoService referenciaOrigemParcelamentoService, RetencaoContabilService retencaoContabilService, ObjectMapper objectMapper) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.lancamentoCreditoRepository = lancamentoCreditoRepository;
        this.formaCorrecaoService = formaCorrecaoService;
        this.mudancaMonetariaService = mudancaMonetariaService;
        this.referenciaOrigemParcelamentoService = referenciaOrigemParcelamentoService;
        this.retencaoContabilService = retencaoContabilService;
        this.objectMapper = objectMapper;
    }
}

