/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornolancamentocredito;

import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.simam.EstornoDebitoLancamentoCredito;
import br.com.elotech.tributos.domain.simam.EstornoDebitoLancamentoCreditoID;
import br.com.elotech.tributos.domain.simam.EstornoLancamentoCredito;
import br.com.elotech.tributos.dto.simam.EstornoLancamentoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.EstornoLancamentoCreditoBatchRepository;
import br.com.elotech.tributos.repository.simam.EstornoLancamentoCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoLancamentoCreditoBatchProcessor
implements ItemProcessor<EstornoLancamentoCreditoConsultaDTO, EstornoDebitoLancamentoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstornoLancamentoCreditoBatchProcessor.class);
    private StepExecution stepExecution;
    private AtomicLong ultimoNrEstorno = new AtomicLong(0L);
    private Long nrAnoEstorno;
    private Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final EntityManager entityManager;
    private final EstornoLancamentoCreditoBatchRepository estornoLancamentoCreditoBatchRepository;
    private final EstornoLancamentoCreditoRepository estornoLancamentoCreditoRepository;
    private final ObjectMapper objectMapper;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        LOGGER.info("SIM-AM - Estorno Lan\u00e7amento Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {} ", (Object)dataInicial, (Object)dataFinal);
        this.ultimoNrEstorno.set(this.estornoLancamentoCreditoBatchRepository.findNextNrEstornoByExercicio(Long.valueOf(dataInicial.getYear())));
        this.nrAnoEstorno = dataInicial.getYear();
        LOGGER.info("SIM-AM - Estorno Lan\u00e7amento Cr\u00e9dito - load da carga existente");
        this.estornoLancamentoCreditoRepository.getCargaExistenteEstornoLancamentoCredito(entidade, dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getId()));
    }

    public EstornoDebitoLancamentoCredito process(EstornoLancamentoCreditoConsultaDTO dto) {
        String chave = String.format("%d-%d-%d-%s", dto.getNrCredito(), dto.getNrAnoCredito(), dto.getCdControleLeiAto(), dto.getDtEstorno().toString());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextVal = this.sequenceGeneratorRepository.getNextVal("s_estornolancamentocredito_id");
            EstornoLancamentoCredito estornoLancamentoCredito = new EstornoLancamentoCredito();
            estornoLancamentoCredito.setId(nextVal);
            estornoLancamentoCredito.setNrEstorno(Long.valueOf(this.ultimoNrEstorno.getAndIncrement()));
            estornoLancamentoCredito.setNrAnoEstorno(this.nrAnoEstorno);
            estornoLancamentoCredito.setNrCredito(dto.getNrCredito());
            estornoLancamentoCredito.setNrAnoCredito(dto.getNrAnoCredito());
            estornoLancamentoCredito.setCdControleLeiAto(dto.getCdControleLeiAto());
            estornoLancamentoCredito.setDtEstorno(dto.getDtEstorno());
            estornoLancamentoCredito.setVlEstorno(dto.getVlEstorno());
            estornoLancamentoCredito.setDsMotivo(dto.getDsMotivo());
            LOGGER.info("SIM-AM - Estorno Lan\u00e7amento Cr\u00e9dito - gerando novo registro -> {} ({}/{})", new Object[]{nextVal, estornoLancamentoCredito.getNrEstorno(), estornoLancamentoCredito.getNrAnoEstorno()});
            this.estornoLancamentoCreditoBatchRepository.save((Object)estornoLancamentoCredito);
            this.entityManager.flush();
            return nextVal;
        });
        EstornoDebitoLancamentoCreditoID estornoDebitoLancamentoCreditoID = new EstornoDebitoLancamentoCreditoID();
        estornoDebitoLancamentoCreditoID.setIdTceInscCreditoDAEst((EstornoLancamentoCredito)this.entityManager.getReference(EstornoLancamentoCredito.class, (Object)finalId));
        estornoDebitoLancamentoCreditoID.setIdDebitoParcelaReceita((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)dto.getIdDebitoParcelaReceita()));
        EstornoDebitoLancamentoCredito estornoDebitoLancamentoCredito = new EstornoDebitoLancamentoCredito();
        estornoDebitoLancamentoCredito.setId(estornoDebitoLancamentoCreditoID);
        estornoDebitoLancamentoCredito.setValor(dto.getVlEstorno());
        return estornoDebitoLancamentoCredito;
    }

    @OnProcessError
    public void onProcessError(EstornoLancamentoCreditoBatchProcessor item, Exception e) throws JsonProcessingException {
        LOGGER.error("SIM-AM - Estorno Lan\u00e7amento Cr\u00e9dito - erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }

    @Generated
    public EstornoLancamentoCreditoBatchProcessor(SequenceGeneratorRepository sequenceGeneratorRepository, EntityManager entityManager, EstornoLancamentoCreditoBatchRepository estornoLancamentoCreditoBatchRepository, EstornoLancamentoCreditoRepository estornoLancamentoCreditoRepository, ObjectMapper objectMapper) {
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.entityManager = entityManager;
        this.estornoLancamentoCreditoBatchRepository = estornoLancamentoCreditoBatchRepository;
        this.estornoLancamentoCreditoRepository = estornoLancamentoCreditoRepository;
        this.objectMapper = objectMapper;
    }
}

