/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornoarrecadacaocredito;

import br.com.elotech.tributos.domain.simam.EstornoArrecadacaoCreditoCreditoContribuinte;
import br.com.elotech.tributos.domain.simam.EstornoArrecadacaoCreditoPagamento;
import br.com.elotech.tributos.domain.simam.EstornoArrecadacaoCreditoRetencaoContabil;
import br.com.elotech.tributos.domain.simam.EstornoTipoArrecadacaoCredito;
import br.com.elotech.tributos.domain.simam.TipoArrecadacaoCredito;
import br.com.elotech.tributos.repository.simam.EstornoArrecadacaoCreditoCreditoContribuinteRepository;
import br.com.elotech.tributos.repository.simam.EstornoArrecadacaoCreditoPagamentoRepository;
import br.com.elotech.tributos.repository.simam.EstornoArrecadacaoCreditoRetencaoRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class EstornoArrecadacaoCreditoBatchWriter
implements ItemWriter<EstornoTipoArrecadacaoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstornoArrecadacaoCreditoBatchWriter.class);
    private static String PREFIXO = "SIM-AM -Estorno Arrecada\u00e7\u00e3o de Cr\u00e9dito - ";
    private final EstornoArrecadacaoCreditoCreditoContribuinteRepository estornoArrecadacaoCreditoCreditoContribuinteRepository;
    private final EstornoArrecadacaoCreditoPagamentoRepository estornoArrecadacaoCreditoPagamentoRepository;
    private final EstornoArrecadacaoCreditoRetencaoRepository estornoArrecadacaoCreditoRetencaoRepository;
    private StepExecution stepExecution;
    private final EntityManager entityManager;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends TipoArrecadacaoCredito> items) {
        LOGGER.info(PREFIXO + "Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends EstornoTipoArrecadacaoCredito> items) {
        List creditos = items.stream().filter(item -> item instanceof EstornoArrecadacaoCreditoCreditoContribuinte).map(EstornoArrecadacaoCreditoCreditoContribuinte.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(item -> item instanceof EstornoArrecadacaoCreditoPagamento).map(EstornoArrecadacaoCreditoPagamento.class::cast).collect(Collectors.toList());
        List retencoes = items.stream().filter(item -> item instanceof EstornoArrecadacaoCreditoRetencaoContabil).map(EstornoArrecadacaoCreditoRetencaoContabil.class::cast).collect(Collectors.toList());
        this.estornoArrecadacaoCreditoCreditoContribuinteRepository.saveAll(creditos);
        this.estornoArrecadacaoCreditoPagamentoRepository.saveAll(pagamentos);
        this.estornoArrecadacaoCreditoRetencaoRepository.saveAll(retencoes);
        this.entityManager.flush();
    }

    @Generated
    public EstornoArrecadacaoCreditoBatchWriter(EstornoArrecadacaoCreditoCreditoContribuinteRepository estornoArrecadacaoCreditoCreditoContribuinteRepository, EstornoArrecadacaoCreditoPagamentoRepository estornoArrecadacaoCreditoPagamentoRepository, EstornoArrecadacaoCreditoRetencaoRepository estornoArrecadacaoCreditoRetencaoRepository, EntityManager entityManager) {
        this.estornoArrecadacaoCreditoCreditoContribuinteRepository = estornoArrecadacaoCreditoCreditoContribuinteRepository;
        this.estornoArrecadacaoCreditoPagamentoRepository = estornoArrecadacaoCreditoPagamentoRepository;
        this.estornoArrecadacaoCreditoRetencaoRepository = estornoArrecadacaoCreditoRetencaoRepository;
        this.entityManager = entityManager;
    }
}

