/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.ajustenrcreditoenrdivida.readers;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.ArrecadacaoTipoCreditoMaDTO;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class AtribuirNrCreditoNrDividaArrecadacaoCreditoReader
extends JdbcCursorItemReader<ArrecadacaoTipoCreditoMaDTO> {
    public AtribuirNrCreditoNrDividaArrecadacaoCreditoReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)((Date)jobParameters.get("dataInicial")));
        this.setFetchSize(1);
        this.setName("arrecadacaoAtribuirNrDivida");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoTipoCreditoMaDTO.class));
        String sql = " select t.idtcearrtipocredito as id,         t.nrarrecadacao,         t.nranoarrecadacao,         t.idtipoorigemreceita,         t.nrcredito,         t.nranocredito,         t.nrdivida,         t.nranodivida,         t.idtipoarrecadacao,         t.nrmes,         t.nrano,         t.vlarrecadacao as valorArrecadacao,         t.idtipocredito  from tcearrecadacaotipocredito t  where t.nrmes = :mes  and t.nrano = :ano  and (        ((t.nrcredito is null or t.nranocredito is null) and t.idtipoorigemreceita = 1 )        or  ((t.nrdivida is null or t.nranodivida is null) and t.idtipoorigemreceita = 2 ))";
        String sqlWithAppliedParams = sql.replace(":mes", Integer.toString(dataInicial.getMonthValue())).replace(":ano", Integer.toString(dataInicial.getYear()));
        this.setSql(sqlWithAppliedParams);
    }
}

