/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.sanepar.processamento;

import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.repository.sanepar.BaixaSaneparItemRepository;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ProcessamentoSaneparWriter
implements ItemWriter<BaixaSaneparItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoSaneparWriter.class);
    private final BaixaSaneparItemRepository repository;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends BaixaSaneparItem> items) throws Exception {
        List naoNulos = items.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (naoNulos.isEmpty()) {
            return;
        }
        this.repository.saveAll(naoNulos);
        this.repository.flush();
    }

    @AfterWrite
    public void afterWrite(List<? extends BaixaSaneparItem> items) {
        int quantidadeProcessada = this.stepExecution.getReadCount() + items.size();
        log.debug(String.format("Itens processados at\u00e9 o momento: %s", quantidadeProcessada));
    }

    @Generated
    public ProcessamentoSaneparWriter(BaixaSaneparItemRepository repository) {
        this.repository = repository;
    }
}

