/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.sanepar.importacao;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.sanepar.BaixaSaneparService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ImportacaoSaneparJobListener
extends JobExecutionListenerSupport {
    private final BaixaSaneparService baixaSaneparService;
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idBaixa = jobExecution.getJobParameters().getLong("idBaixa");
        this.baixaSaneparService.iniciarImportacao(idBaixa);
        Optional notificacaoId = this.notificacaoService.send(String.format("Iniciada a importa\u00e7\u00e3o do arquivo de baixa da Sanepar %d.", idBaixa), null, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idBaixa = jobExecution.getJobParameters().getLong("idBaixa");
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.baixaSaneparService.finalizarImportacao(idBaixa);
            this.notificacaoService.send(String.format("Finalizada a importa\u00e7\u00e3o da baixa da Sanepar %d.", idBaixa), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.baixaSaneparService.limparHash(idBaixa);
            this.notificacaoService.send(String.format("Ocorreu um erro na importa\u00e7\u00e3o da baixa da Sanepar %d.", idBaixa), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public ImportacaoSaneparJobListener(BaixaSaneparService baixaSaneparService, NotificacaoService notificacaoService) {
        this.baixaSaneparService = baixaSaneparService;
        this.notificacaoService = notificacaoService;
    }
}

