/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.relatoriogerencialarrecadacao.lancamentoarrecadacao;

import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.ArrecadacaoAnual;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.ArrecadacaoAnualId;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.ArrecadacaoAnualMes;
import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.ArrecadacaoAnualMesId;
import br.com.elotech.tributos.dto.relatoriogerencial.AnaliseArrecadacaoRequest;
import br.com.elotech.tributos.dto.relatoriogerencial.LancamentoArrecadacaoDTO;
import br.com.elotech.tributos.repository.relatoriogerencial.ArrecadacaoAnualRepository;
import br.com.elotech.tributos.service.relatoriogerencial.lancamentoarrecadacao.LancamentoArrecadacaoService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LancamentoArrecadacaoProcessor
implements ItemProcessor<AnaliseArrecadacaoRequest, ArrecadacaoAnual> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LancamentoArrecadacaoProcessor.class);
    private final LancamentoArrecadacaoService lancamentoArrecadacaoService;
    private final ArrecadacaoAnualRepository arrecadacaoAnualRepository;

    public ArrecadacaoAnual process(AnaliseArrecadacaoRequest request) {
        Long entidade = request.getEntidade();
        Long exercicio = request.getExercicio();
        Long mesAnalise = request.getMesAnalise();
        return this.toEntity(this.lancamentoArrecadacaoService.carregaLancamentoArrecadacao(entidade, exercicio, mesAnalise));
    }

    private void adicionaNovoMes(LancamentoArrecadacaoDTO dto, ArrecadacaoAnualMesId id, ArrecadacaoAnual arrecadacaoAnual) {
        ArrecadacaoAnualMes novoMes = this.getArrecadacaoAnualMes(dto, id, arrecadacaoAnual);
        arrecadacaoAnual.getArrecadacaoMes().add(novoMes);
    }

    public ArrecadacaoAnual toEntity(LancamentoArrecadacaoDTO dto) {
        Long exercicio;
        Long entidade = dto.getEntidade();
        ArrecadacaoAnualId anualId = new ArrecadacaoAnualId(entidade, exercicio = dto.getExercicio());
        ArrecadacaoAnual arrecadacaoAnual = (ArrecadacaoAnual)this.arrecadacaoAnualRepository.findOne((Object)anualId);
        if (!Objects.nonNull(arrecadacaoAnual)) {
            arrecadacaoAnual = new ArrecadacaoAnual();
            arrecadacaoAnual.setId(anualId);
            arrecadacaoAnual.setArrecadacaoMes(new ArrayList());
        }
        arrecadacaoAnual.setLancamentoAnual(dto.getLancamentoAnual());
        arrecadacaoAnual.setQtdeCadastroCancelado(dto.getQtdeCadastroCancelado());
        arrecadacaoAnual.setQtdeCadastroDesconto(dto.getQtdeCadastroDesconto());
        arrecadacaoAnual.setQtdeCadastroLancamento(dto.getQtdeCadastroLancamento());
        arrecadacaoAnual.setQtdeCadastroParcAno(dto.getQtdeCadastroParcAno());
        arrecadacaoAnual.setQtdeCadastroRenuncia(dto.getQtdeCadastroRenuncia());
        arrecadacaoAnual.setQtdeCadastroRenunciaZerado(dto.getQtdeCadastroRenunciaZerado());
        arrecadacaoAnual.setQtdeCadastroRestanteArrecadar(dto.getQtdeCadastroRestanteArrecadar());
        arrecadacaoAnual.setUltimoMovimento(LocalDate.now());
        ArrecadacaoAnualMesId id = new ArrecadacaoAnualMesId(entidade, exercicio, dto.getMesAnalise());
        ArrecadacaoAnual novoArrecadacaoAnual = arrecadacaoAnual;
        arrecadacaoAnual.getArrecadacaoMes().stream().filter(m -> Objects.equals(m.getId(), id)).findFirst().ifPresentOrElse(m -> this.updateArrecadacaoAnualMes(dto, m), () -> this.adicionaNovoMes(dto, id, novoArrecadacaoAnual));
        return arrecadacaoAnual;
    }

    private ArrecadacaoAnualMes getArrecadacaoAnualMes(LancamentoArrecadacaoDTO dto, ArrecadacaoAnualMesId id, ArrecadacaoAnual arrecadacaoAnual) {
        ArrecadacaoAnualMes arrecadacaoAnualMes = new ArrecadacaoAnualMes();
        arrecadacaoAnualMes.setId(id);
        arrecadacaoAnualMes.setRevisoes(dto.getRevisoesLiquido());
        arrecadacaoAnualMes.setDesconto(dto.getDescontoMes());
        arrecadacaoAnualMes.setArrecadacaoVista(dto.getArrecadacaoAVistaMes());
        arrecadacaoAnualMes.setArrecadacaoParcelado(dto.getArrecadacaoParceladoMes());
        arrecadacaoAnualMes.setQtdeCadastroVista(dto.getQtdeCadastroVista());
        arrecadacaoAnualMes.setQtdeCadastroParcelado(dto.getQtdeCadastroParc());
        arrecadacaoAnualMes.setArrecadacaoAnual(arrecadacaoAnual);
        return arrecadacaoAnualMes;
    }

    private void updateArrecadacaoAnualMes(LancamentoArrecadacaoDTO dto, ArrecadacaoAnualMes arrecadacaoAnualMes) {
        arrecadacaoAnualMes.setRevisoes(dto.getRevisoesLiquido());
        arrecadacaoAnualMes.setDesconto(dto.getDescontoMes());
        arrecadacaoAnualMes.setArrecadacaoVista(dto.getArrecadacaoAVistaMes());
        arrecadacaoAnualMes.setArrecadacaoParcelado(dto.getArrecadacaoParceladoMes());
        arrecadacaoAnualMes.setQtdeCadastroVista(dto.getQtdeCadastroVista());
        arrecadacaoAnualMes.setQtdeCadastroParcelado(dto.getQtdeCadastroParc());
    }

    @Generated
    public LancamentoArrecadacaoProcessor(LancamentoArrecadacaoService lancamentoArrecadacaoService, ArrecadacaoAnualRepository arrecadacaoAnualRepository) {
        this.lancamentoArrecadacaoService = lancamentoArrecadacaoService;
        this.arrecadacaoAnualRepository = arrecadacaoAnualRepository;
    }
}

