/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.relatoriogerencialarrecadacao.lancamentoarrecadacao;

import br.com.elotech.tributos.domain.relatoriogerencialarrecadacao.ArrecadacaoAnual;
import br.com.elotech.tributos.repository.relatoriogerencial.ArrecadacaoAnualRepository;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class LancamentoArrecadacaoBatchWriter
implements ItemWriter<ArrecadacaoAnual> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LancamentoArrecadacaoBatchWriter.class);
    private final EntityManager entityManager;
    private final ArrecadacaoAnualRepository arrecadacaoAnualRepository;
    private StepExecution stepExecution;

    public LancamentoArrecadacaoBatchWriter(EntityManager entityManager, ArrecadacaoAnualRepository arrecadacaoAnualRepository) {
        this.entityManager = entityManager;
        this.arrecadacaoAnualRepository = arrecadacaoAnualRepository;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends ArrecadacaoAnual> items) throws Exception {
        this.arrecadacaoAnualRepository.saveAll(items);
        this.entityManager.flush();
    }

    @AfterStep
    public void afterStep() {
        Long mesAnalise = this.stepExecution.getJobExecution().getJobParameters().getLong("mesAnalise");
        log.info("Persistindo Arrecadacao Anual referente ao m\u00eas {}.", (Object)mesAnalise);
    }
}

