/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.relatoriogerencialarrecadacao.acompanhamentoperiodo;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class AcompanhamentoPeriodoJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AcompanhamentoPeriodoJobListener.class);
    private final NotificacaoService notificacaoService;
    private static final String ID_NOTIFICACAO = "idNotificacao";

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long exercicio = jobExecution.getJobParameters().getLong("exercicio");
        Long mes = jobExecution.getJobParameters().getLong("mes");
        Long dia = jobExecution.getJobParameters().getLong("dia");
        Object notificacao = String.format("Iniciada a atualiza\u00e7\u00e3o do acompanhamento por per\u00edodo referente a %d/%d", mes, exercicio);
        if (!Objects.equals(dia, 0L)) {
            notificacao = (String)notificacao + String.format(" e dia %d.", dia);
        }
        Optional notificacaoId = this.notificacaoService.send((String)notificacao, null, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        NotificationStatus status;
        super.afterJob(jobExecution);
        Long exercicio = jobExecution.getJobParameters().getLong("exercicio");
        Long mes = jobExecution.getJobParameters().getLong("mes");
        Long dia = jobExecution.getJobParameters().getLong("dia");
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        Object notificacao = "";
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            notificacao = String.format("Finalizada a atualiza\u00e7\u00e3o do acompanhamento por per\u00edodo referente ao per\u00edodo %d/%d", mes, exercicio);
            status = NotificationStatus.COMPLETED;
        } else {
            notificacao = String.format("Ocorreu um erro na atualiza\u00e7\u00e3o do acompanhamento por per\u00edodo referente ao per\u00edodo %d/%d", mes, exercicio);
            status = NotificationStatus.FAILED;
        }
        if (!Objects.equals(dia, 0L)) {
            notificacao = (String)notificacao + String.format(" e dia %d.", dia);
        }
        this.notificacaoService.send((String)notificacao, null, jobExecution, Optional.of(notificacaoId), status);
    }

    @Generated
    public AcompanhamentoPeriodoJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

