/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaRetornoDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRelatorioRetornoDTO;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ProtestoRemessaItemService;
import br.com.elotech.tributos.service.ProtestoRemessaService;
import br.com.elotech.tributos.service.integracaoprotestocra.IntegracaoProtestoCraService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class GerarProtestoRemessaBatchWriter
implements ItemWriter<List<ProtestoRemessaItem>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarProtestoRemessaBatchWriter.class);
    private static final String ID_PROTESTO_REMESSA = "idProtestoRemessa";
    private final ProtestoRemessaItemService protestoRemessaItemService;
    private final ProtestoRemessaService protestoRemessaService;
    private final IntegracaoProtestoCraService integracaoProtestoCraService;
    private final ParametroGeralService parametroGeralService;
    private Long idRemessa;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.idRemessa = stepExecution.getJobParameters().getLong(ID_PROTESTO_REMESSA);
    }

    public void write(List<? extends List<ProtestoRemessaItem>> items) throws Exception {
        log.debug("Salvando itens da remessa de protesto para a remessa com id {}", (Object)this.idRemessa);
        List flattenedItems = items.stream().flatMap(Collection::stream).collect(Collectors.toList());
        this.protestoRemessaItemService.saveAll(flattenedItems);
    }

    @AfterStep
    public ExitStatus afterStep(StepExecution stepExecution) {
        boolean utilizaWebService = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_WEBSERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        try {
            if (utilizaWebService) {
                boolean hasComarcaComErro;
                Long idProtestoRemessa = stepExecution.getJobParameters().getLong(ID_PROTESTO_REMESSA);
                ProtestoRemessa protestoRemessa = (ProtestoRemessa)this.protestoRemessaService.findOne((Serializable)idProtestoRemessa);
                log.debug("Iniciando gera\u00e7\u00e3o do XML e envio da remessa com id {} para o CRA", (Object)idProtestoRemessa);
                CraRelatorioRetornoDTO craRelatorioRetornoDTO = this.integracaoProtestoCraService.enviarRemessa(protestoRemessa);
                if (craRelatorioRetornoDTO.isEnvioComErro()) {
                    stepExecution.setStatus(BatchStatus.FAILED);
                    stepExecution.setExitStatus(ExitStatus.FAILED.addExitDescription("Falha ao enviar remessa para o CRA: \nNome do Arquivo: " + craRelatorioRetornoDTO.getNomeArquivo() + "\nC\u00f3digo da Ocorr\u00eancia: " + craRelatorioRetornoDTO.getCodigo() + "\nOcorr\u00eancia: " + craRelatorioRetornoDTO.getOcorrencia() + "\n"));
                    return stepExecution.getExitStatus();
                }
                boolean bl = hasComarcaComErro = !craRelatorioRetornoDTO.getComarcas().stream().allMatch(CraComarcaRetornoDTO::isRegistrosOk);
                if (hasComarcaComErro) {
                    StringBuilder failedDescription = new StringBuilder("Falha ao enviar remessa para o CRA: \n");
                    craRelatorioRetornoDTO.getComarcas().stream().filter(comarca -> !comarca.isRegistrosOk()).forEach(comarca -> failedDescription.append("C\u00f3digo da Ocorr\u00eancia: ").append(comarca.getCodigo()).append("\n").append("Ocorr\u00eancia: ").append(comarca.getOcorrencia()).append("\n"));
                    stepExecution.setStatus(BatchStatus.FAILED);
                    stepExecution.setExitStatus(ExitStatus.FAILED.addExitDescription(failedDescription.toString()));
                    return stepExecution.getExitStatus();
                }
                log.debug("Verifica\u00e7\u00e3o de erros no relat\u00f3rio de retorno do CRA. Nome do Arquivo: {}, C\u00f3digo: {}, Ocorr\u00eancia: {}, Envio com Erro: {}, Comarca com Erro: {}", new Object[]{craRelatorioRetornoDTO.getNomeArquivo(), craRelatorioRetornoDTO.getCodigo(), craRelatorioRetornoDTO.getOcorrencia(), craRelatorioRetornoDTO.isEnvioComErro(), hasComarcaComErro});
            }
            return ExitStatus.COMPLETED;
        }
        catch (Exception e) {
            stepExecution.setStatus(BatchStatus.FAILED);
            stepExecution.setExitStatus(ExitStatus.FAILED.addExitDescription((Throwable)e));
            return stepExecution.getExitStatus();
        }
    }

    @Generated
    public GerarProtestoRemessaBatchWriter(ProtestoRemessaItemService protestoRemessaItemService, ProtestoRemessaService protestoRemessaService, IntegracaoProtestoCraService integracaoProtestoCraService, ParametroGeralService parametroGeralService) {
        this.protestoRemessaItemService = protestoRemessaItemService;
        this.protestoRemessaService = protestoRemessaService;
        this.integracaoProtestoCraService = integracaoProtestoCraService;
        this.parametroGeralService = parametroGeralService;
    }
}

