/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.integracaoboleto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class IntegracaoBoletoPixItauBatchWriter
implements ItemWriter<IntegracaoBoletoPixLog> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegracaoBoletoPixItauBatchWriter.class);
    private final EntityManager entityManager;
    private final IntegracaoBoletoPixLogRepository integracaoQrCodeCodigoBarrasRepository;
    private StepExecution stepExecution;

    public IntegracaoBoletoPixItauBatchWriter(EntityManager entityManager, IntegracaoBoletoPixLogRepository integracaoQrCodeCodigoBarrasRepository) {
        this.entityManager = entityManager;
        this.integracaoQrCodeCodigoBarrasRepository = integracaoQrCodeCodigoBarrasRepository;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends IntegracaoBoletoPixLog> items) {
        IntegracaoBoletoPixLog integracao = (IntegracaoBoletoPixLog)items.stream().findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o possui items"));
        LOGGER.info("Salvando os dados do envio de c\u00f3digos de barra para o Banco Read count {}. Job Id {}.", (Object)this.stepExecution.getReadCount(), (Object)this.stepExecution.getJobExecution().getId());
        this.integracaoQrCodeCodigoBarrasRepository.saveAll(items);
        this.entityManager.flush();
    }
}

