/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.geracaodebitocalculo;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class GeracaoDebitoCalculoBatchReader
extends JdbcPagingItemReader<Long> {
    public GeracaoDebitoCalculoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) throws Exception {
        this.setFetchSize(10);
        this.setName("idCalculoCadastroConsistente");
        this.setDataSource(dataSource);
        this.setRowMapper((rs, rowNum) -> rs.getLong("id"));
        this.setQueryProvider(this.queryProvider(jobParameters, dataSource).getObject());
    }

    private SqlPagingQueryProviderFactoryBean queryProvider(Map<String, Object> jobParameters, DataSource dataSource) {
        Long idCalculo = (Long)jobParameters.get("idCalculo");
        SqlPagingQueryProviderFactoryBean provider = new SqlPagingQueryProviderFactoryBean();
        provider.setDataSource(dataSource);
        provider.setSelectClause("SELECT id");
        provider.setFromClause("FROM calculocadastro cc");
        provider.setWhereClause(String.format("WHERE cc.calculo = %d and not exists ( select *  from calculoinconsistencia ci  where cc.id = ci.calculocadastro) ", idCalculo));
        provider.setSortKey("id");
        return provider;
    }
}

