/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.estornoatualizacaomonetaria;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.DebitoTributo;
import br.com.elotech.tributos.domain.parcelamento.EstornoAtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.EstornoAtualizacaoMonetariaItem;
import br.com.elotech.tributos.domain.parcelamento.EstornoAtualizacaoMonetariaItemId;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.DebitosEstornoAtualizacaoDTO;
import br.com.elotech.tributos.repository.parcelamento.EstornoAtualizacaoMonetariaItemRepository;
import br.com.elotech.tributos.service.DebitoTributoService;
import br.com.elotech.tributos.service.EstornoAtualizacaoMonetariaService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoAtualizacaoMonetariaParcelamentoBatchWriter
implements ItemWriter<DebitosEstornoAtualizacaoDTO> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EstornoAtualizacaoMonetariaParcelamentoBatchWriter.class);
    private final DebitoTributoService debitoTributoService;
    private final EstornoAtualizacaoMonetariaItemRepository estornoAtualizacaoMonetariaItemRepository;
    private final EstornoAtualizacaoMonetariaService estornoAtualizacaoMonetariaService;
    private EstornoAtualizacaoMonetaria estornoAtualizacaoMonetaria;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        Long idEstorno = stepExecution.getJobParameters().getLong("idEstornoAtualizacaoMonetaria");
        this.estornoAtualizacaoMonetaria = (EstornoAtualizacaoMonetaria)this.estornoAtualizacaoMonetariaService.findOne((Serializable)idEstorno);
    }

    public void write(List<? extends DebitosEstornoAtualizacaoDTO> items) {
        Map<Long, BigDecimal> valorParaAtualizar = items.stream().map(item -> {
            EstornoAtualizacaoMonetariaItemId idItem = new EstornoAtualizacaoMonetariaItemId();
            idItem.setIdEstorno(this.estornoAtualizacaoMonetaria.getId());
            idItem.setIdAtualizacaoMonetaria(this.estornoAtualizacaoMonetaria.getAtualizacaoMonetaria().getId());
            idItem.setIdDebitoParcelaTributo(item.getIdDebitoParcelaTributo());
            EstornoAtualizacaoMonetariaItem itemEstorno = new EstornoAtualizacaoMonetariaItem();
            itemEstorno.setId(idItem);
            this.estornoAtualizacaoMonetariaItemRepository.save((Object)itemEstorno);
            return item;
        }).collect(Collectors.groupingBy(DebitosEstornoAtualizacaoDTO::getIdDebitoTributo, Collectors.reducing(BigDecimal.ZERO, DebitosEstornoAtualizacaoDTO::getValorAtualizacao, BigDecimal::add)));
        valorParaAtualizar.forEach((idDebitoTributo, valor) -> {
            if (valor.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            DebitoTributo debitoTributo = (DebitoTributo)this.debitoTributoService.findByIdDebitoTributo(idDebitoTributo).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar d\u00e9bito tributo com o id %d", idDebitoTributo)));
            if (debitoTributo.getValorTributo().compareTo((BigDecimal)valor) < 0) {
                throw new EloValidationException(String.format("O d\u00e9bito tributo %d n\u00e3o possui valor suficiente para realizar o estorno da atualiza\u00e7\u00e3o monet\u00e1ria. Valor atual: %.2f, valor que tentou ser estornado: %.2f", idDebitoTributo, debitoTributo.getValorTributo(), valor));
            }
            debitoTributo.setValorTributo(debitoTributo.getValorTributo().subtract((BigDecimal)valor));
            this.debitoTributoService.save((EloEntity)debitoTributo, null);
        });
    }

    @Generated
    public EstornoAtualizacaoMonetariaParcelamentoBatchWriter(DebitoTributoService debitoTributoService, EstornoAtualizacaoMonetariaItemRepository estornoAtualizacaoMonetariaItemRepository, EstornoAtualizacaoMonetariaService estornoAtualizacaoMonetariaService) {
        this.debitoTributoService = debitoTributoService;
        this.estornoAtualizacaoMonetariaItemRepository = estornoAtualizacaoMonetariaItemRepository;
        this.estornoAtualizacaoMonetariaService = estornoAtualizacaoMonetariaService;
    }
}

