/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.enviopeticaoprocuradoria;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.procuradoria.client.feign.EnviaPeticaoProcuradoriaFeignClient;
import br.com.elotech.tributos.domain.EnvioLotePeticao;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.repository.documento.EnvioLotePeticaoRepository;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class EnvioPeticaoProcuradoriaJobListener
extends JobExecutionListenerSupport {
    private static final String ID = "idLote";
    private static final String ID_ENVIO_LOTE_PETICAO = "idEnvioLotePeticao";
    private static final String JOB_TYPE = "jobType";
    private static final String NOTIFICACAO_ID = "notificacaoId";
    private static final String ENVIA_LOTE_PETICAO_PROCURADORIA = JobType.ENVIA_LOTE_PETICAO_PROCURADORIA.getTipo();
    private final NotificacaoService notificacaoService;
    private final Optional<EnviaPeticaoProcuradoriaFeignClient> enviaPeticaoProcuradoriaFeignClient;
    private final EnvioLotePeticaoRepository envioPeticaoRepository;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idLote = jobExecution.getJobParameters().getLong(ID);
        Long idEnvioLotePeticao = jobExecution.getJobParameters().getLong(ID_ENVIO_LOTE_PETICAO);
        Optional envioLotePeticao = this.envioPeticaoRepository.findById((Object)idEnvioLotePeticao);
        if (!envioLotePeticao.isPresent()) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar nenhum Lote Envio Peti\u00e7\u00e3o com id: %d.", idEnvioLotePeticao));
        }
        EnvioLotePeticao lotePeticao = (EnvioLotePeticao)envioLotePeticao.get();
        lotePeticao.setIdJob(BatchJobExecution.of((JobExecution)jobExecution));
        this.envioPeticaoRepository.saveAndFlush((Object)lotePeticao);
        Optional notificacaoId = this.notificacaoService.send(String.format("Iniciada a gera\u00e7\u00e3o do arquivo agrupado com a Peti\u00e7\u00e3o e a CDAs do Lote %d.", idLote), String.format("Foi iniciada a gera\u00e7\u00e3o do arquivo agrupado com a Peti\u00e7\u00e3o e a CDAs do Lote %d.", idLote), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(NOTIFICACAO_ID, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().get(NOTIFICACAO_ID).toString());
        Long idLote = jobExecution.getJobParameters().getLong(ID);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.enviaPeticaoProcuradoriaFeignClient.ifPresent(EnviaPeticaoProcuradoriaFeignClient::sendNotifications);
            this.notificacaoService.send(String.format("Arquivo agrupado da Peti\u00e7\u00f5es do Lote %d disponibilizado para a Procuradoria.", idLote), String.format("Gera\u00e7\u00e3o do arquivo agrupado para envio para Procuradoria finalizada com sucesso.", idLote), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send(String.format("Erro na gera\u00e7\u00e3o do arquivo agrupado para envio para Procuradoria do Lote %d.", idLote), String.format("N\u00e3o foi poss\u00edvel gerar o arquivo do Lote %d para a Procuradoria.", idLote), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public EnvioPeticaoProcuradoriaJobListener(NotificacaoService notificacaoService, Optional<EnviaPeticaoProcuradoriaFeignClient> enviaPeticaoProcuradoriaFeignClient, EnvioLotePeticaoRepository envioPeticaoRepository) {
        this.notificacaoService = notificacaoService;
        this.enviaPeticaoProcuradoriaFeignClient = enviaPeticaoProcuradoriaFeignClient;
        this.envioPeticaoRepository = envioPeticaoRepository;
    }
}

