/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.descontobaixaautomatica;

import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteService;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.NotFoundException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class DescontoBaixaAutomaticaDetalheProcessor
implements ItemProcessor<BaixaAutomaticaDetalhe, BaixaAutomaticaDetalhe> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DescontoBaixaAutomaticaDetalheProcessor.class);
    private final Map<String, Object> jobParameters;
    private final DebitoObservacaoService debitoObservacaoService;
    private final ProcessaPagamentoLoteService processaPagamentoLoteService;
    private final MotivoDeducaoService motivoDeducaoService;
    private StepExecution stepExecution;
    private MotivoDeducao motivoDeducao;

    public DescontoBaixaAutomaticaDetalheProcessor(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DebitoObservacaoService debitoObservacaoService, ProcessaPagamentoLoteService processaPagamentoLoteService, MotivoDeducaoService motivoDeducaoService) {
        this.jobParameters = jobParameters;
        this.debitoObservacaoService = debitoObservacaoService;
        this.processaPagamentoLoteService = processaPagamentoLoteService;
        this.motivoDeducaoService = motivoDeducaoService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.motivoDeducao = this.getMotivoDeducaoPagoMenorParametrizado();
    }

    private MotivoDeducao getMotivoDeducaoPagoMenorParametrizado() {
        Long motivoDeducaoId = (Long)this.jobParameters.get("motivoDeducaoId");
        return (MotivoDeducao)this.motivoDeducaoService.findById((Serializable)motivoDeducaoId).orElseThrow(() -> new NotFoundException("N\u00e3o encontrado Motivo de Dedu\u00e7\u00e3o com id " + motivoDeducaoId));
    }

    public BaixaAutomaticaDetalhe process(BaixaAutomaticaDetalhe item) throws Exception {
        boolean descontoAplicado = this.setDesconto(item);
        if (descontoAplicado) {
            this.setObservacao(item);
        }
        return item;
    }

    private void setObservacao(BaixaAutomaticaDetalhe item) {
        String observacao = (String)this.jobParameters.get("observacao");
        if (Objects.isNull(observacao)) {
            return;
        }
        item.getBoleto().getDebitos().stream().map(boletoDebito -> boletoDebito.getId().getDebitoParcelaTributo().getDebitoParcela().getDebito()).map(DebitoIdDTO::from).distinct().forEach(debitoIdDTO -> {
            log.debug("Setando observacao para o d\u00e9bito {} ", (Object)debitoIdDTO.getIdDebito());
            this.debitoObservacaoService.save(debitoIdDTO, observacao);
        });
    }

    private boolean setDesconto(BaixaAutomaticaDetalhe item) {
        if (Objects.isNull(this.motivoDeducao)) {
            return false;
        }
        log.debug("Setando desconto para a baixa {}", (Object)item.getId().getSequenciaArquivo());
        this.processaPagamentoLoteService.setValoresDesconto(item, this.motivoDeducao, TipoMensagemEnum.DESCONTO_CONCEDIDO);
        return true;
    }
}

