/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.debitoautomatico.remessa;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.debitoautomatico.DebitoAutomaticoRemessaItemDTO;
import br.com.elotech.tributos.dto.debitoautomatico.RemessaDebitoAutomaticoFilterDTO;
import br.com.elotech.tributos.repository.DebitoAutomaticoOpcaoRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class RemessaArquivoDebitoAutomaticoReader
extends JdbcCursorItemReader<DebitoAutomaticoRemessaItemDTO> {
    private static final String GERAR_DEBITOS_AUTOMATICOS_REMESSA = "br/com/elotech/tributos/repository/gerar-debito-automatico-remessa.sql";

    public RemessaArquivoDebitoAutomaticoReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, ObjectMapper objectMapper, DebitoAutomaticoOpcaoRepository debitoAutomaticoOpcaoRepository) throws Exception {
        RemessaDebitoAutomaticoFilterDTO filtro = (RemessaDebitoAutomaticoFilterDTO)objectMapper.readValue((String)jobParameters.get("filtro"), RemessaDebitoAutomaticoFilterDTO.class);
        this.setFetchSize(1000);
        this.setName("remessaArquivoDebitoAutomatico");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(DebitoAutomaticoRemessaItemDTO.class));
        this.setSql(this.getFullSql(filtro));
    }

    private String getFullSql(RemessaDebitoAutomaticoFilterDTO filtro) {
        String sql = FileUtils.readResourceAsString((String)GERAR_DEBITOS_AUTOMATICOS_REMESSA);
        sql = sql.replace("$[FILTROS]", filtro.buildFiltro());
        if (Objects.nonNull(filtro.getConvenio())) {
            sql = sql.replace(":convenio", "'" + filtro.getConvenio().toString() + "'");
        }
        if (Objects.nonNull(filtro.getFormaPagamento())) {
            sql = sql.replace(":formaPagamento", "'" + filtro.getFormaPagamento().toString() + "'");
        }
        if (Objects.nonNull(filtro.getDataAutorizacaoInicial())) {
            sql = sql.replace(":dataAutorizacaoInicial", "'" + filtro.getDataAutorizacaoInicial().toString() + "'");
        }
        if (Objects.nonNull(filtro.getDataAutorizacaoFinal())) {
            sql = sql.replace(":dataAutorizacaoFinal", "'" + filtro.getDataVencimentoFinal().toString() + "'");
        }
        if (Objects.nonNull(filtro.getDataVencimentoInicial())) {
            sql = sql.replace(":dataVencimentoInicial", "'" + filtro.getDataVencimentoInicial().toString() + "'");
        }
        if (Objects.nonNull(filtro.getDataVencimentoFinal())) {
            sql = sql.replace(":dataVencimentoFinal", "'" + filtro.getDataVencimentoFinal().toString() + "'");
        }
        return sql;
    }
}

