/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.debitoautomatico.importacao;

import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoAutomaticoOpcao;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItem;
import br.com.elotech.tributos.dto.debitoautomatico.ADAItemB;
import br.com.elotech.tributos.repository.BancoRepository;
import br.com.elotech.tributos.repository.ConvenioRepository;
import br.com.elotech.tributos.repository.DebitoAutomaticoOpcaoRepository;
import br.com.elotech.tributos.repository.FormaPagamentoRepository;
import br.com.elotech.tributos.util.UsuarioUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ImportacaoArquivoDebitoAutomaticoWriter
implements ItemWriter<ADAItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoDebitoAutomaticoWriter.class);
    private static final Long EXCLUSAO_OPTANTE = 1L;
    private static final Long INCLUSAO_OPTANTE = 2L;
    private final DebitoAutomaticoOpcaoRepository debitoAutomaticoOpcaoRepository;
    private final BancoRepository bancoRepository;
    private final ConvenioRepository convenioRepository;
    private final FormaPagamentoRepository formaPagamentoRepository;
    private StepExecution stepExecution;
    private Banco banco;
    private Convenio convenio;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends ADAItem> items) throws Exception {
        Long codigoBanco = this.stepExecution.getExecutionContext().getLong("codigoBanco");
        this.banco = (Banco)this.bancoRepository.findOne((Object)codigoBanco);
        String numeroConvenio = this.stepExecution.getExecutionContext().getString("codigoConvenio");
        this.convenio = this.convenioRepository.findByEntidadeAndNumeroConvenioAndBancoId(Long.valueOf(1L), numeroConvenio, codigoBanco);
        for (ADAItem aDAItem : items) {
            if (!(aDAItem instanceof ADAItemB)) continue;
            ADAItemB itemB = (ADAItemB)aDAItem;
            DebitoAutomaticoOpcao debitoAutomaticoOpcao = new DebitoAutomaticoOpcao();
            Optional debitoAutomaticoOpcaoOptional = this.debitoAutomaticoOpcaoRepository.findByDebitoCompositeKey(itemB.getEntidade(), itemB.getExercicio(), itemB.getTipoCadastro(), itemB.getCadastroGeral(), itemB.getGuiaRecolhimento(), itemB.getSubdivida());
            if (debitoAutomaticoOpcaoOptional.isPresent()) {
                debitoAutomaticoOpcao = (DebitoAutomaticoOpcao)debitoAutomaticoOpcaoOptional.get();
            }
            debitoAutomaticoOpcao.setIdentificacao(itemB.getIdentificacaoClienteBanco());
            debitoAutomaticoOpcao.setIdentificacaoOrigem(itemB.getIdentificacaoClienteEmpresa());
            if (EXCLUSAO_OPTANTE.compareTo(itemB.getCodigoMovimento()) == 0) {
                debitoAutomaticoOpcao.setDataExclusao(itemB.getDataOpcaoExclusao());
                debitoAutomaticoOpcao.setUsuarioExclusao(UsuarioUtils.getUsuarioAise());
            }
            if (INCLUSAO_OPTANTE.compareTo(itemB.getCodigoMovimento()) == 0) {
                debitoAutomaticoOpcao.setDataImplantacao(LocalDate.now());
                debitoAutomaticoOpcao.setDataAutorizacao(itemB.getDataOpcaoExclusao());
                debitoAutomaticoOpcao.setUsuario(UsuarioUtils.getUsuarioAise());
            }
            debitoAutomaticoOpcao.setBanco(this.banco);
            debitoAutomaticoOpcao.setConvenio(this.convenio);
            debitoAutomaticoOpcao.setAgencia(itemB.getAgenciaDebito());
            FormaPagamento formaPagamento = (FormaPagamento)this.formaPagamentoRepository.findOne((Object)itemB.getFormaPagamento());
            debitoAutomaticoOpcao.setFormaPagamento(formaPagamento);
            debitoAutomaticoOpcao.setEntidade(itemB.getEntidade());
            debitoAutomaticoOpcao.setExercicio(itemB.getExercicio());
            debitoAutomaticoOpcao.setTipoCadastro(itemB.getTipoCadastro());
            debitoAutomaticoOpcao.setCadastroGeral(itemB.getCadastroGeral());
            debitoAutomaticoOpcao.setGuiaRecolhimento(itemB.getGuiaRecolhimento());
            debitoAutomaticoOpcao.setSubDivida(itemB.getSubdivida());
            this.debitoAutomaticoOpcaoRepository.save((Object)debitoAutomaticoOpcao);
        }
    }

    @Generated
    public ImportacaoArquivoDebitoAutomaticoWriter(DebitoAutomaticoOpcaoRepository debitoAutomaticoOpcaoRepository, BancoRepository bancoRepository, ConvenioRepository convenioRepository, FormaPagamentoRepository formaPagamentoRepository) {
        this.debitoAutomaticoOpcaoRepository = debitoAutomaticoOpcaoRepository;
        this.bancoRepository = bancoRepository;
        this.convenioRepository = convenioRepository;
        this.formaPagamentoRepository = formaPagamentoRepository;
    }
}

