/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.createlivrodividaativa;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.LivroId;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.exception.JobParameterSerializationException;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaBatchService;
import br.com.elotech.tributos.service.LivroService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.implementations.InscricaoDividaAtivaNotifier;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.transaction.Transactional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
@Transactional
public class LivroDividaAtivaJobListener
extends JobExecutionListenerSupport {
    private static final String LIVRO = "livro";
    private final Logger log = LoggerFactory.getLogger(LivroDividaAtivaJobListener.class);
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService;
    private final ObjectMapper objectMapper;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final LivroService livroService;
    private final FormaPagamentoService formaPagamentoService;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final InscricaoDividaAtivaNotifier inscricaoDividaAtivaNotifier;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        FiltroGeraLivroDTO filtro = this.getFiltroFromJobParameters(jobExecution.getJobParameters());
        Boolean inscricaoPorParcela = "P".equals(jobExecution.getJobParameters().getString("inscricaoPorParcela"));
        Boolean englobaDebitos = this.getEnglobaDebito(inscricaoPorParcela);
        Livro livro = this.getLivroFromParameters(jobExecution.getJobParameters());
        Date dataInscricaoParametro = jobExecution.getJobParameters().getDate("dataInscricao");
        Optional notificacaoId = this.notificacaoService.send("Gera\u00e7\u00e3o do livro de d\u00edvida ativa iniciado", "Foi iniciada a gera\u00e7\u00e3o do l\u00edvro de divida ativa", jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
        if (Objects.isNull(dataInscricaoParametro)) {
            this.log.warn("Job execution {} sem data de inscri\u00e7\u00e3o no parametro, utilizando data atual.", (Object)jobExecution.getId());
            dataInscricaoParametro = new Date();
        }
        LocalDate dataInscricao = DateUtils.dateToLocalDate((Date)dataInscricaoParametro);
        this.validaDataMovimentacaoService.validaMesEDia(livro.getId().getEntidade(), dataInscricao);
        livro.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
        this.livroService.save((EloEntity)livro, null);
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        jobExecution.getExecutionContext().put(LIVRO, (Object)livro);
        jobExecution.getExecutionContext().put("filtro", (Object)filtro);
        jobExecution.getExecutionContext().put("inscricaoPorParcela", (Object)inscricaoPorParcela);
        jobExecution.getExecutionContext().put("englobaDebitos", (Object)englobaDebitos);
        jobExecution.getExecutionContext().put("formaPagamentoPadrao", (Object)formaPagamentoPadrao);
        jobExecution.getExecutionContext().put("dataInscricao", (Object)dataInscricao);
    }

    private Livro getLivroFromParameters(JobParameters jobParameters) {
        try {
            LivroId livroId = (LivroId)this.objectMapper.readValue(jobParameters.getString("livroId"), LivroId.class);
            return (Livro)this.livroService.findOne((Serializable)livroId);
        }
        catch (IOException e) {
            throw new JobParameterSerializationException("Erro ao deserializar o livro no parametro do job", (Throwable)e);
        }
    }

    private FiltroGeraLivroDTO getFiltroFromJobParameters(JobParameters jobParameters) {
        try {
            return (FiltroGeraLivroDTO)this.objectMapper.readValue(jobParameters.getString("filtro"), FiltroGeraLivroDTO.class);
        }
        catch (IOException e) {
            throw new JobParameterSerializationException("Erro ao deserializar o filtro no parametro do job", (Throwable)e);
        }
    }

    private Boolean getEnglobaDebito(Boolean inscricaoPorParcela) {
        Boolean englobaDebitos = this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.ENGLOBA_DEBITO_DIVIDA_ATIVA).map(ParametroEntidadeExercicio::getValor).map("S"::equals).orElse(Boolean.FALSE);
        if (inscricaoPorParcela.booleanValue() && englobaDebitos.booleanValue()) {
            throw new EloValidationException("Par\u00e2metro Tipo Inscri\u00e7\u00e3o D\u00edvida Ativa configurado errado. N\u00e3o \u00e9 poss\u00edvel englobar parcelas com tipo inscri\u00e7\u00e3o por parcela.");
        }
        return englobaDebitos;
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        this.notifyAfterJob(jobExecution);
    }

    private void notifyAfterJob(JobExecution jobExecution) {
        this.notifyClient(jobExecution);
        this.notifyAgendamentoExecutor(jobExecution);
    }

    private void notifyClient(JobExecution jobExecution) {
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            Livro livro = (Livro)jobExecution.getExecutionContext().get(LIVRO);
            this.geraLivroDividaAtivaBatchService.atualizarValorPai(livro);
            Long exercicio = livro.getId().getExercicio();
            Long numeroLivro = livro.getId().getLivro();
            this.notificacaoService.send("Gera\u00e7\u00e3o do livro de d\u00edvida ativa finalizada com sucesso", String.format("A gera\u00e7\u00e3o do livro %d/%d foi finalizada com sucesso.", numeroLivro, exercicio), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Erro na gera\u00e7\u00e3o do livro de d\u00edvida ativa", "N\u00e3o foi poss\u00edvel realizar a gera\u00e7\u00e3o do livro.", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    private void notifyAgendamentoExecutor(JobExecution jobExecution) {
        Optional.ofNullable(jobExecution.getJobParameters().getLong("idAgendamento")).ifPresent(idAgendamento -> this.inscricaoDividaAtivaNotifier.notify(idAgendamento, (Object)jobExecution));
    }

    @Generated
    public LivroDividaAtivaJobListener(NotificacaoService notificacaoService, GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService, ObjectMapper objectMapper, ParametroEntidadeExercicioService parametroEntidadeExercicioService, LivroService livroService, FormaPagamentoService formaPagamentoService, ValidaDataMovimentacaoService validaDataMovimentacaoService, InscricaoDividaAtivaNotifier inscricaoDividaAtivaNotifier) {
        this.notificacaoService = notificacaoService;
        this.geraLivroDividaAtivaBatchService = geraLivroDividaAtivaBatchService;
        this.objectMapper = objectMapper;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.livroService = livroService;
        this.formaPagamentoService = formaPagamentoService;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.inscricaoDividaAtivaNotifier = inscricaoDividaAtivaNotifier;
    }
}

