/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.createlivrodividaativa;

import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaTributoDTO;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaBatchService;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class LivroDividaAtivaBatchWriter
implements ItemWriter<Map<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LivroDividaAtivaBatchWriter.class);
    private final GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService;
    private final EntityManager entityManager;
    private StepExecution stepExecution;

    public LivroDividaAtivaBatchWriter(GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService, EntityManager entityManager) {
        this.geraLivroDividaAtivaBatchService = geraLivroDividaAtivaBatchService;
        this.entityManager = entityManager;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends Map<LivroRegistro, List<GeraLivroDebitoParcelaTributoDTO>>> items) {
        LOGGER.info("Atualizando a situa\u00e7\u00e3o das parcelas. Read count {}. Job Id {}.", (Object)this.stepExecution.getReadCount(), (Object)this.stepExecution.getJobExecution().getId());
        items.forEach(arg_0 -> ((GeraLivroDividaAtivaBatchService)this.geraLivroDividaAtivaBatchService).alterarSituacaoParcela(arg_0));
        this.entityManager.flush();
    }
}

