/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.contenciosorecalculo;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.ContenciosoArquivoS3;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.repository.ContenciosoArquivoS3Repository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.util.ByteMultipartFile;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ContenciosoRecalculoBoletoJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContenciosoRecalculoBoletoJobListener.class);
    private final NotificacaoService notificacaoService;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final ContenciosoArquivoS3Repository contenciosoArquivoS3Repository;
    private static final String ID_NOTIFICACAO = "idNotificacao";

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idContencioso = jobExecution.getJobParameters().getLong("idContencioso");
        Optional notificacaoId = this.notificacaoService.send(String.format("Iniciado a gera\u00e7\u00e3o de boleto/carn\u00ea para o contencioso %d.", idContencioso), null, jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idContencioso = jobExecution.getJobParameters().getLong("idContencioso");
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (jobExecution.getExecutionContext().containsKey("tempFile")) {
            String nomeArquivo = jobExecution.getJobParameters().getString("nomeArquivo");
            String tempFile = jobExecution.getExecutionContext().getString("tempFile");
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("idContencioso", idContencioso.toString());
            try {
                Long idArquivoS3 = this.saveZipAndUploadArquivoS3(tempFile, metadata, nomeArquivo);
                ContenciosoArquivoS3 contenciosoArquivoS3 = new ContenciosoArquivoS3();
                contenciosoArquivoS3.setIdContencioso(idContencioso);
                contenciosoArquivoS3.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
                contenciosoArquivoS3.setIdArquivoS3(idArquivoS3);
                contenciosoArquivoS3.setNomeArquivo(nomeArquivo);
                this.contenciosoArquivoS3Repository.saveAndFlush((Object)contenciosoArquivoS3);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send(String.format("Finalizado a gera\u00e7\u00e3o de boleto/carn\u00ea do contencioso %d.", idContencioso), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send(String.format("Ocorreu um erro na gera\u00e7\u00e3o de boleto/carn\u00ea do contencioso %d.", idContencioso), null, jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    private Long saveZipAndUploadArquivoS3(String tempFile, HashMap<String, String> metadata, String nomeArquivo) throws IOException {
        try (InputStream fileStream = Files.newInputStream(Paths.get(tempFile, new String[0]), StandardOpenOption.READ);){
            ByteMultipartFile byteMultipartFile = new ByteMultipartFile(fileStream.readAllBytes(), "application/octet-stream");
            ArquivoDTO arquivoDTO = new ArquivoDTO(null, nomeArquivo, SecurityUtils.getUserId(), TipoArquivoEnum.OUTROS, Modulo.OXY_TRIBUTOS, "/contencioso/boleto", LocalDate.now(), "application/octet-stream", null, null, metadata);
            Long l = this.arquivoStorageFeignClient.createWithFile(arquivoDTO, (MultipartFile)byteMultipartFile).getId();
            return l;
        }
    }

    @Generated
    public ContenciosoRecalculoBoletoJobListener(NotificacaoService notificacaoService, ArquivoStorageFeignClient arquivoStorageFeignClient, ContenciosoArquivoS3Repository contenciosoArquivoS3Repository) {
        this.notificacaoService = notificacaoService;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.contenciosoArquivoS3Repository = contenciosoArquivoS3Repository;
    }
}

