/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.consultadebito;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.exception.JobParameterSerializationException;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.NotificacaoService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ConsultaDebitoJobListener
extends JobExecutionListenerSupport {
    private static final String CONSULTA_DEBITO = "consultaDebito";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final ObjectMapper objectMapper;
    private final FormaPagamentoService formaPagamentoService;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        FiltroConsultaDebitoDTO filtro = this.getFiltroFromJobParameters(jobExecution.getJobParameters());
        ConsultaDebito consultaDebito = (ConsultaDebito)this.consultaDebitoBatchService.findById((Serializable)jobExecution.getJobParameters().getLong("idConsulta")).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a consulta de d\u00e9bitos."));
        consultaDebito.setBatchJobExecution(BatchJobExecution.of((JobExecution)jobExecution));
        this.consultaDebitoBatchService.save((EloEntity)consultaDebito, null);
        FormaPagamento formaPagamentoPadrao = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        jobExecution.getExecutionContext().put(CONSULTA_DEBITO, (Object)consultaDebito);
        jobExecution.getExecutionContext().put("filtro", (Object)filtro);
        jobExecution.getExecutionContext().put("formaPagamentoPadrao", (Object)formaPagamentoPadrao);
        Optional notificacaoId = this.notificacaoService.send("Gera\u00e7\u00e3o da consulta de d\u00e9bitos foi iniciado", "Foi iniciada a gera\u00e7\u00e3o da consulta de d\u00e9bitos", jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        ConsultaDebito consultaDebito = (ConsultaDebito)jobExecution.getExecutionContext().get(CONSULTA_DEBITO);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Gera\u00e7\u00e3o da consulta dos d\u00e9bitos finalizada com sucesso", String.format("Gera\u00e7\u00e3o da consulta dos d\u00e9bitos: %d finalizada com sucesso", consultaDebito.getId()), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Erro na consulta dos d\u00e9bitos", String.format("N\u00e3o foi poss\u00edvel realizar a consulta dos d\u00e9bitos %d.", consultaDebito.getId()), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    private FiltroConsultaDebitoDTO getFiltroFromJobParameters(JobParameters jobParameters) {
        try {
            return (FiltroConsultaDebitoDTO)this.objectMapper.readValue(Objects.requireNonNull(jobParameters.getString("filtro")), FiltroConsultaDebitoDTO.class);
        }
        catch (IOException e) {
            throw new JobParameterSerializationException("Erro ao desserializar o filtro no par\u00e2metro do job", (Throwable)e);
        }
    }

    @Generated
    public ConsultaDebitoJobListener(NotificacaoService notificacaoService, ObjectMapper objectMapper, FormaPagamentoService formaPagamentoService, ConsultaDebitoBatchService consultaDebitoBatchService) {
        this.notificacaoService = notificacaoService;
        this.objectMapper = objectMapper;
        this.formaPagamentoService = formaPagamentoService;
        this.consultaDebitoBatchService = consultaDebitoBatchService;
    }
}

