/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.manual;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ComunicadoManualJobListener
extends JobExecutionListenerSupport {
    private static final String JOB_TYPE = "jobType";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;
    private final ComunicadoRepository comunicadoRepository;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        ComunicadoId comunicadoId = new ComunicadoId();
        JobParameters jobParameters = Objects.requireNonNull(jobExecution.getJobParameters());
        comunicadoId.setEntidade(jobParameters.getLong("entidade"));
        comunicadoId.setExercicio(jobParameters.getLong("exercicioComunicado"));
        comunicadoId.setIdComunicado(jobParameters.getLong("idComunicado"));
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        comunicado.setBatchJobExecutionComunicado(BatchJobExecution.of((JobExecution)jobExecution));
        this.comunicadoRepository.save((Object)comunicado);
        Optional notificacaoId = this.notificacaoService.send("Gera\u00e7\u00e3o de comunicado manual - iniciado", "Foi iniciado a rotina de gera\u00e7\u00e3o de comunicado", jobExecution, Optional.empty(), NotificationStatus.COMPLETED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        ComunicadoId comunicadoId = new ComunicadoId();
        comunicadoId.setIdComunicado(jobExecution.getJobParameters().getLong("idComunicado"));
        comunicadoId.setEntidade(jobExecution.getJobParameters().getLong("entidade"));
        comunicadoId.setExercicio(jobExecution.getJobParameters().getLong("exercicio"));
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Gera\u00e7\u00e3o de comunicado manual - Finalizado", "Foi finalizado a rotina de gera\u00e7\u00e3o de comunicado com sucesso", jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Gera\u00e7\u00e3o de comunicado manual - erro", "Foi finalizado a rotina de gera\u00e7\u00e3o de comunicado com erro", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public ComunicadoManualJobListener(NotificacaoService notificacaoService, ComunicadoRepository comunicadoRepository) {
        this.notificacaoService = notificacaoService;
        this.comunicadoRepository = comunicadoRepository;
    }
}

