/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.protesto;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.dto.LoteCdaItemDTO;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class GeracaoProtestoLoteCdaBatchReader
extends JdbcCursorItemReader<LoteCdaItemDTO> {
    public GeracaoProtestoLoteCdaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        Long idLote = (Long)jobParameters.get("idLote");
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/find-cda-nao-protestado.sql").replace(":idLoteCda", idLote.toString()).replace(":protestoGerado", String.valueOf(SituacaoLoteCda.PROTESTO_GERADO.getValue())).replace(":gerandoProtesto", String.valueOf(SituacaoLoteCda.GERANDO_PROTESTO.getValue()));
        this.setFetchSize(1000);
        this.setName("protestoGeracaoCda");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(LoteCdaItemDTO.class));
        this.setSql(sql);
    }
}

