/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.protesto;

import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.LoteCdaItemDTO;
import br.com.elotech.tributos.service.documento.cda.LoteCdaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class GeracaoProtestoLoteCdaBatchProcessor
implements ItemProcessor<LoteCdaItemDTO, Protesto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeracaoProtestoLoteCdaBatchProcessor.class);
    private static final String LOG_PARAM = "Gera\u00e7\u00e3o de Protesto - ";
    private final LoteCdaService loteCdaService;
    protected StepExecution stepExecution;
    private JobExecution jobExecution;

    public GeracaoProtestoLoteCdaBatchProcessor(LoteCdaService loteCdaService) {
        this.loteCdaService = loteCdaService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.jobExecution = this.stepExecution.getJobExecution();
        LOGGER.info("Gera\u00e7\u00e3o de Protesto - Iniciando gera\u00e7\u00e3o de dados");
    }

    public Protesto process(LoteCdaItemDTO item) throws Exception {
        return this.loteCdaService.protestarLoteCda(item, this.jobExecution);
    }
}

