/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.calculoalteracaovencimentoparcela;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class CalculoAlteracaoVencimentoParcelaJobListener
extends JobExecutionListenerSupport {
    private static final String ID = "idCalculo";
    private static final String JOB_TYPE = "jobType";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private static final String CALCULO_ALTERACAO_VENCIMENTO_PARCELA = JobType.CALCULO_ALTERACAO_VENCIMENTO_PARCELA.getTipo();
    private final NotificacaoService notificacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID);
        Optional notificacaoId = this.notificacaoService.send("Altera\u00e7\u00e3o do vencimento dos carn\u00eas iniciada.", String.format("Foi iniciada a altera\u00e7\u00e3o do vencimento por parcela dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d.", idCalculo), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idCalculo = jobExecution.getJobParameters().getLong(ID);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Altera\u00e7\u00e3o do vencimento dos carn\u00eas finalizada.", String.format("Foi finalizada a altera\u00e7\u00e3o do vencimento por parcela dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d.", idCalculo), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Erro na Altera\u00e7\u00e3o do vencimento dos carn\u00eas.", String.format("Erro na altera\u00e7\u00e3o do vencimento por parcela dos carn\u00eas dos lotes de impress\u00e3o do c\u00e1lculo %d.", idCalculo), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public CalculoAlteracaoVencimentoParcelaJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

