/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.baixaautomatica;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class BaixaAutomaticaBatchReader
extends JdbcPagingItemReader<BaixaAutomaticaDetalheId> {
    public BaixaAutomaticaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) throws Exception {
        this.setFetchSize(1);
        this.setName("baixaAutomaticaId");
        this.setDataSource(dataSource);
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(BaixaAutomaticaDetalheId.class));
        this.setQueryProvider(this.queryProvider(jobParameters, dataSource).getObject());
    }

    private SqlPagingQueryProviderFactoryBean queryProvider(Map<String, Object> jobParameters, DataSource dataSource) {
        SqlPagingQueryProviderFactoryBean provider = new SqlPagingQueryProviderFactoryBean();
        Long entidade = (Long)jobParameters.get("entidade");
        Long exercicio = (Long)jobParameters.get("exercicio");
        Long lote = (Long)jobParameters.get("lote");
        provider.setDataSource(dataSource);
        provider.setSelectClause("SELECT entidade, exercicio, lote, sequenciaarquivo ");
        provider.setFromClause("FROM TRIBBAIXAAUTOMATICADETALHE ");
        provider.setWhereClause("WHERE situacao in ('V', 'D', 'A') and " + String.format("entidade = %d and exercicio = %d and lote = %d", entidade, exercicio, lote));
        provider.setSortKey("sequenciaarquivo");
        return provider;
    }
}

