/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.baixaautomatica;

import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.ProcessaPagamentoLoteService;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class BaixaAutomaticaBatchProcessor
implements ItemProcessor<BaixaAutomaticaDetalheId, BaixaAutomaticaDetalhe> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaixaAutomaticaBatchProcessor.class);
    private ProcessaPagamentoLoteService processaPagamentoLoteService;
    private BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private StepExecution stepExecution;

    public BaixaAutomaticaBatchProcessor(ProcessaPagamentoLoteService processaPagamentoLoteService, BaixaAutomaticaDetalheService baixaAutomaticaDetalheService) {
        this.processaPagamentoLoteService = processaPagamentoLoteService;
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public BaixaAutomaticaDetalhe process(BaixaAutomaticaDetalheId item) {
        LOGGER.debug("ExecutionId: {}, StepId: {}, ReadCount: {}", new Object[]{this.stepExecution.getJobExecution().getId(), this.stepExecution.getId(), this.stepExecution.getReadCount()});
        LOGGER.debug("Realizando a baixa do registro {}", (Object)item);
        BaixaAutomaticaDetalhe baixaAutomaticaDetalhe = (BaixaAutomaticaDetalhe)this.baixaAutomaticaDetalheService.findOne((Serializable)item);
        baixaAutomaticaDetalhe.verificaSituacaoSequenciaBaixa();
        return this.processaPagamentoLoteService.geraPagamento(item);
    }
}

