/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.alteracaocadastroemmassa;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Optional;
import java.util.UUID;
import javax.transaction.Transactional;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
@Transactional
public class EdicaoEmMassaJobListener
extends JobExecutionListenerSupport {
    private final NotificacaoService notificacaoService;
    private static final String ID_NOTIFICACAO = "idNotificacao";

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Optional notificacaoId = this.notificacaoService.send("Edi\u00e7\u00e3o em massa iniciada.", "Foi iniciada a edi\u00e7\u00e3o em massa dos cadastros.", jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Edi\u00e7\u00e3o em massa finalizada.", "A edi\u00e7\u00e3o em massa dos cadastros foi finalizada com sucesso.", jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Edi\u00e7\u00e3o em massa falhou.", "A edi\u00e7\u00e3o em massa dos cadastros falhou.", jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public EdicaoEmMassaJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

