/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.alteracaocadastroemmassa;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.edicaoemmassa.IEdicaoEmMassa;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.enums.TipoEdicaoEmMassa;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.edicaoemmassa.EdicaoEmMassaImobiliarioService;
import br.com.elotech.tributos.service.edicaoemmassa.EdicaoEmMassaMobiliarioService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EdicaoEmMassaBatchProcessor
implements ItemProcessor<Long, IEdicaoEmMassa> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdicaoEmMassaBatchProcessor.class);
    private StepExecution stepExecution;
    private final EdicaoEmMassaImobiliarioService edicaoEmMassaImobiliarioService;
    private final EdicaoEmMassaMobiliarioService edicaoEmMassaMobiliarioService;
    private final EntityManager entityManager;
    private final ObjectMapper objectMapper;
    private String tipo;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.loadContext(stepExecution);
    }

    public IEdicaoEmMassa process(@NotNull Long id) throws Exception {
        Object cadastro = this.tipo.equals(TipoEdicaoEmMassa.MOBILIARIO.toString()) ? this.processMobiliario(id) : this.processImobiliario(id);
        if (Objects.nonNull(cadastro)) {
            cadastro.setDataAlteracao(LocalDate.now());
            cadastro.setUsuario(SecurityUtils.getUserAise());
        }
        return cadastro;
    }

    protected void loadContext(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        this.tipo = this.stepExecution.getJobExecution().getJobParameters().getString("tipo");
    }

    private CadastroGeral processImobiliario(Long idCadastro) throws Exception {
        LOGGER.info("Edicao de cadastro imobili\u00e1rio em massa - Processando cadastro de id: {}. Read Count: {}", (Object)idCadastro, (Object)this.stepExecution.getReadCount());
        JobParameters jobParameters = this.stepExecution.getJobExecution().getJobParameters();
        EdicaoEmMassaFiltroDTO filtro = (EdicaoEmMassaFiltroDTO)this.objectMapper.readValue(jobParameters.getString("filtro"), EdicaoEmMassaFiltroDTO.class);
        CadastroImobiliario cadastro = (CadastroImobiliario)this.entityManager.getReference(CadastroImobiliario.class, (Object)idCadastro);
        if (Objects.nonNull(filtro)) {
            this.edicaoEmMassaImobiliarioService.handleChangeCadastro(filtro, cadastro);
        }
        return cadastro;
    }

    private CadastroMobiliario processMobiliario(Long idCadastro) throws Exception {
        LOGGER.info("Edicao de cadastro mobili\u00e1rio em massa - Processando cadastro de id: {}. Read Count: {}", (Object)idCadastro, (Object)this.stepExecution.getReadCount());
        JobParameters jobParameters = this.stepExecution.getJobExecution().getJobParameters();
        EdicaoEmMassaFiltroDTO filtro = (EdicaoEmMassaFiltroDTO)this.objectMapper.readValue(jobParameters.getString("filtro"), EdicaoEmMassaFiltroDTO.class);
        CadastroMobiliario cadastro = (CadastroMobiliario)this.entityManager.getReference(CadastroMobiliario.class, (Object)idCadastro);
        if (Objects.nonNull(filtro)) {
            this.edicaoEmMassaMobiliarioService.handleChangeCadastro(filtro, cadastro);
        }
        return cadastro;
    }

    @Generated
    public EdicaoEmMassaBatchProcessor(EdicaoEmMassaImobiliarioService edicaoEmMassaImobiliarioService, EdicaoEmMassaMobiliarioService edicaoEmMassaMobiliarioService, EntityManager entityManager, ObjectMapper objectMapper) {
        this.edicaoEmMassaImobiliarioService = edicaoEmMassaImobiliarioService;
        this.edicaoEmMassaMobiliarioService = edicaoEmMassaMobiliarioService;
        this.entityManager = entityManager;
        this.objectMapper = objectMapper;
    }
}

