/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos;

import br.com.elotech.tributos.CalculoAcrescimoRolException;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.RolDividaTributoDTO;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.repository.RolCustomRepository;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"applicationtest"})
public class CalculoAcrescimoRolComponent
implements ApplicationRunner {
    private static final Logger LOG = LoggerFactory.getLogger(CalculoAcrescimoRolComponent.class);
    private static final String OK_STRING = String.format("%24s", "OK");
    private static final String VALORES_STRING = "%10.2f <> %10.2f";
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final FormaPagamentoService formaPagamentoService;
    private final RolCustomRepository rolCustomRepository;

    @Autowired
    public CalculoAcrescimoRolComponent(CalculoAcrescimoService calculoAcrescimoService, FormaPagamentoService formaPagamentoService, RolCustomRepository rolCustomRepository) {
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.formaPagamentoService = formaPagamentoService;
        this.rolCustomRepository = rolCustomRepository;
    }

    public void testaCalculaAcrescimos(Long idRol, LocalDate dataReferencia) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        LOG.info("Carregando ROL");
        List listaRol = this.rolCustomRepository.findRolDividaTributo(idRol);
        LOG.info("Criando lista de acrescimos");
        List listaAcrescimos = this.getListaAcrescimoDTO(dataReferencia, formaPagamento, listaRol);
        ArrayList<ImmutablePair> listaRolAcrescimos = new ArrayList<ImmutablePair>();
        for (int i = 0; i < listaRol.size(); ++i) {
            listaRolAcrescimos.add(ImmutablePair.of((Object)((RolDividaTributoDTO)listaRol.get(i)), (Object)((AcrescimoDTO)listaAcrescimos.get(i))));
        }
        int umPorcento = listaRolAcrescimos.size() / 100;
        StopWatch stopWatch = StopWatch.createStarted();
        AtomicLong contador = new AtomicLong(0L);
        AtomicLong inconsistencias = new AtomicLong(0L);
        try {
            listaRolAcrescimos.parallelStream().forEach(pair -> {
                AcrescimoDTO registroAcrescimo = (AcrescimoDTO)pair.getRight();
                RolDividaTributoDTO registroRol = (RolDividaTributoDTO)pair.getLeft();
                this.calculoAcrescimoService.calculaAcrescimos(registroAcrescimo, Optional.empty());
                Long processados = contador.incrementAndGet();
                if (this.comparaValores(processados, registroAcrescimo, registroRol).booleanValue()) {
                    inconsistencias.incrementAndGet();
                }
                if (processados % (long)umPorcento == 0L) {
                    LOG.info("{}%", (Object)(processados / (long)umPorcento));
                }
            });
        }
        catch (RuntimeException re) {
            throw new CalculoAcrescimoRolException(re.getMessage());
        }
        stopWatch.stop();
        LOG.info("Tempo gasto: {} ", (Object)stopWatch);
        LOG.info("* Total de items: {}", (Object)listaRolAcrescimos.size());
        LOG.info("* Total de inconsist\u00eancias: {}", (Object)inconsistencias.get());
    }

    private Boolean comparaValores(Long index, AcrescimoDTO dto, RolDividaTributoDTO rol) {
        String textValor = OK_STRING;
        String textValorJuros = OK_STRING;
        String textValorMulta = OK_STRING;
        String textValorCorrecao = OK_STRING;
        if (rol.getValorAtualizado().compareTo(dto.getValor()) != 0) {
            textValor = String.format(VALORES_STRING, rol.getValorAtualizado(), dto.getValor());
        }
        if (rol.getValorJuros().compareTo(dto.getValorJuros()) != 0) {
            textValorJuros = String.format(VALORES_STRING, rol.getValorJuros(), dto.getValorJuros());
        }
        if (rol.getValorMulta().compareTo(dto.getValorMulta()) != 0) {
            textValorMulta = String.format(VALORES_STRING, rol.getValorMulta(), dto.getValorMulta());
        }
        if (rol.getValorCorrecao().compareTo(dto.getValorCorrecao()) != 0) {
            textValorCorrecao = String.format(VALORES_STRING, rol.getValorCorrecao(), dto.getValorCorrecao());
        }
        if (!(textValor.equals(OK_STRING) && textValorJuros.equals(OK_STRING) && textValorMulta.equals(OK_STRING) && textValorCorrecao.equals(OK_STRING))) {
            String info = String.format("[%7d][idDebito:%10d, parcela:%3d, tributo:%3s] valor:%s - valorCorrecao:%s - valorMulta:%s - valorJuros:%s", index, rol.getIdDebito(), rol.getParcela(), rol.getTributo(), textValor, textValorCorrecao, textValorMulta, textValorJuros);
            LOG.error(info);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<AcrescimoDTO> getListaAcrescimoDTO(LocalDate dataReferencia, FormaPagamento formaPagamento, List<RolDividaTributoDTO> listaRol) {
        ArrayList<AcrescimoDTO> result = new ArrayList<AcrescimoDTO>();
        listaRol.forEach(rol -> {
            AcrescimoDTO dto = new AcrescimoDTO();
            dto.setEntidade(rol.getEntidade());
            dto.setExercicio(rol.getExercicio());
            dto.setDataReferencia(dataReferencia);
            dto.setDataLancamento(rol.getDataLancamento());
            dto.setDataVencimento(rol.getDataVencimento());
            dto.setFormaCorrecao(rol.getFormaCorrecao());
            dto.setFormaPagamento(formaPagamento.getId());
            dto.setSituacaoLegal(SituacaoLegal.fromValue((Integer)rol.getSituacaoLegal().intValue()));
            dto.setParcelado(rol.getParcelado());
            dto.setTributo(rol.getTributo());
            DividaDTO dividaDTO = new DividaDTO();
            dividaDTO.setDivida(rol.getDivida());
            dto.setDivida(dividaDTO);
            dto.setValor(rol.getValor());
            result.add(dto);
        });
        return result;
    }

    public void run(ApplicationArguments args) {
        String idRolString = (String)args.getOptionValues("calculo.acrescimo.idrol").get(0);
        String dataReferenciaString = (String)args.getOptionValues("calculo.acrescimo.data-referencia").get(0);
        if (Objects.nonNull(idRolString) && Objects.nonNull(dataReferenciaString) && !idRolString.isEmpty() && !dataReferenciaString.isEmpty()) {
            Long idRol = Long.valueOf(idRolString);
            LocalDate dataReferencia = LocalDate.parse(dataReferenciaString);
            LOG.info("Iniciando testes do Calculo de Acrescimos...");
            LOG.info("* idRol: {}", (Object)idRolString);
            LOG.info("* dataRefer\u00eancia: {}", (Object)dataReferenciaString);
            this.testaCalculaAcrescimos(idRol, dataReferencia);
            LOG.info("Finalizado testes do CalculaAcrescimos.");
        }
    }
}

