select nq.nrCredito as nr,
       nq.nrAnoCredito as nrAno,
       nq.valorSoma as valorSoma
from
(
  select soma.nrCredito,
         soma.nrAnoCredito,
         sum(soma.vlLancamento + soma.vlEstornoLancamento + soma.vlatualizacao + soma.vlEstornoAtualizacao +
             soma.vlDeducao + soma.vlEstornoDeducao + soma.vlInscricao + soma.vlEstornoInscricao +
             soma.vlArrecadacao + soma.vlEstornoArrecadacao) as valorSoma
  from
  (
    select filtro.nrCredito,
           filtro.nrAnoCredito,
           sum(filtro.vlLancamento) as vlLancamento,
           sum(case when tlce.vlEstornoLancamento   is null then 0 else tlce.vlEstornoLancamento end   ) as vlEstornoLancamento,
           sum(case when tamc.vlatualizacao         is null then 0 else tamc.vlatualizacao end         ) as vlatualizacao,
           sum(case when tamce.vlEstornoAtualizacao is null then 0 else tamce.vlEstornoAtualizacao end ) as vlEstornoAtualizacao,
           sum(case when tdc.vlDeducao              is null then 0 else tdc.vlDeducao end              ) as vlDeducao,
           sum(case when tdce.vlEstornoDeducao      is null then 0 else tdce.vlEstornoDeducao end      ) as vlEstornoDeducao,
           sum(case when tic.vlInscricao            is null then 0 else tic.vlInscricao end            ) as vlInscricao,
           sum(case when tice.vlEstornoInscricao    is null then 0 else tice.vlEstornoInscricao end    ) as vlEstornoInscricao,
           sum(case when atc.vlArrecadacao          is null then 0 else atc.vlArrecadacao end          ) as vlArrecadacao,
           sum(case when atce.vlEstornoArrecadacao  is null then 0 else atc.vlArrecadacao end          ) as vlEstornoArrecadacao
    from
    (
      select tlc.nrcredito,
             tlc.nranocredito,
             coalesce(tlc.vllancamento, 0) as vllancamento
      from tceLancCredito tlc
      where tlc.idTipoCredito = :idTipoCredito
        and tlc.dtLancamento <= :dataLancamento
        and tlc.idTipoOperacaoCredito <> 4
    ) filtro
    left join (
      select tlce.nrcredito,
             tlce.nrAnocredito,
             coalesce(sum(tlce.vlEstorno), 0)*-1 as vlEstornoLancamento
      from tcelanccreditoest tlce
      group by tlce.nrCredito, tlce.nrAnoCredito
    ) tlce on tlce.nrcredito = filtro.nrcredito and tlce.nranocredito = filtro.nranocredito
    left join (
      select tamc.nrcredito,
             tamc.nrAnocredito,
             sum(coalesce(tamc.vlAtualizacao, 0)) as vlAtualizacao
      from tceAtualizaMoneCred tamc
      group by tamc.nrCredito, tamc.nrAnoCredito
    ) tamc on tamc.nrcredito = filtro.nrcredito and tamc.nranocredito = filtro.nranocredito
    left join (
      select tamc.nrcredito,
             tamc.nrAnocredito,
             sum(coalesce(tamce.vlEstorno, 0)*-1) as vlEstornoAtualizacao
      from tceAtualizaMoneCredEst tamce
      join tceAtualizaMoneCred tamc on tamc.nrAnoAtualizacao = tamce.nrAnoAtualizacao and tamc.nrAtualizacao = tamce.nrAtualizacao
      group by tamc.nrCredito, tamc.nrAnoCredito
    ) tamce on tamce.nrcredito = filtro.nrcredito and tamce.nranocredito = filtro.nranocredito
    left join (
      select tdc.nrcredito,
             tdc.nrAnocredito,
             sum(coalesce(tdc.vlDeducao, 0)*-1) as vlDeducao
      from tceDeducaoCredito tdc
      group by tdc.nrCredito, tdc.nrAnoCredito
    ) tdc on tdc.nrcredito = filtro.nrcredito and tdc.nranocredito = filtro.nranocredito
    left join (
      select tdc.nrcredito,
             tdc.nrAnocredito,
             sum(coalesce(tdce.vlEstorno, 0)) as vlEstornoDeducao
      from tceDeducaoCreditoEst tdce
      join tceDeducaoCredito tdc on tdc.nrAnoDeducao = tdce.nrAnoDeducao and tdc.nrDeducao = tdce.nrDeducao
      group by tdc.nrCredito, tdc.nrAnoCredito
    ) tdce on tdce.nrcredito = filtro.nrcredito and tdce.nranocredito = filtro.nranocredito
    left join (
      select tic.nrcredito,
             tic.nrAnocredito,
             sum(coalesce(tic.vlInscricao, 0)*-1) as vlInscricao
      from tceinsccreditoda tic
      group by tic.nrCredito, tic.nrAnoCredito
    ) tic on tic.nrcredito = filtro.nrcredito and tic.nranocredito = filtro.nranocredito
    left join (
      select tic.nrcredito,
             tic.nrAnocredito,
             sum(coalesce(tice.vlEstorno, 0)) as vlEstornoInscricao
      from tceinsccreditodaEst tice
      join tceinsccreditoda tic on tic.nrAnoDivida = tice.nrAnoDivida and tic.nrDivida = tice.nrDivida
      group by tic.nrCredito,
               tic.nrAnoCredito
    ) tice on tice.nrcredito = filtro.nrcredito and tice.nranocredito = filtro.nranocredito
    left join (
      select atc.nrcredito,
             atc.nrAnocredito,
             sum(coalesce(atc.vlArrecadacao, 0)*-1) as vlArrecadacao
      from tcearrecadacaotipocredito atc
      where atc.idtipoorigemreceita = 1
        and atc.idtipoarrecadacao <> 3
      group by atc.nrCredito, atc.nrAnoCredito
    ) atc on atc.nrcredito = filtro.nrcredito and atc.nranocredito = filtro.nranocredito
    left join (
      select atc.nrcredito,
             atc.nrAnocredito,
             sum(coalesce(atce.vlEstorno, 0)) as vlEstornoArrecadacao
      from tcearrecadacaotipocreditoEst atce
      join tcearrecadacaotipocredito atc on atc.nrAnoArrecadacao = atce.nrAnoArrecadacao and atc.nrArrecadacao = atce.nrArrecadacao
      where atc.idtipoorigemreceita = 1
        and atc.idtipoarrecadacao <> 3
      group by atc.nrCredito, atc.nrAnoCredito
    ) atce on atce.nrcredito = filtro.nrcredito and atce.nranocredito = filtro.nranocredito
    group by filtro.nrAnoCredito,
             filtro.nrCredito
  ) soma
%s
  and soma.nrAnoCredito = :anoLancamento
  group by soma.nrAnoCredito,
           soma.nrCredito
) nq
order by nq.valorSoma desc