select x.idtcearrtipocredito,
       x.nrAnoArrecadacao,
       x.idTipoOrigemReceita,
       x.idTipoArrecadacao,
       x.nrCredito,
       x.nranocredito,
       x.nrdivida,
       x.nranodivida,
       x.nrMes,
       x.nrAno,
       x.idTipoCredito,
       sum(x.valor) as valor
from (
         select atc.idtcearrtipocredito,
                atc.nrAnoArrecadacao,
                atc.idTipoOrigemReceita,
                atc.idTipoArrecadacao,
                atc.idTipoCredito,
                case when (atc.idTipoOrigemReceita = 1) then atc.nrcredito else null end as nrCredito,
                case when (atc.idTipoOrigemReceita = 1) then atc.nranocredito else null end as nranocredito,
                case when (atc.idTipoOrigemReceita = 2) then atc.nrdivida else null end as nrdivida,
                case when (atc.idTipoOrigemReceita = 2) then atc.nranodivida else null end as nranodivida,
                atc.nrMes,
                atc.nrAno,
                atcp.valor as valor
         from tceArrecadacaoTipoCredito          atc
                  join tceArrTipoCreditoPagamento         atcp on atcp.idtcearrtipocredito = atc.idtcearrtipocredito
                  left join tribpagamentodebito           tpd  on tpd.iddebitoparcelareceita = atcp.iddebitoparcelareceita and tpd.idpagamentobloqueto = atcp.idpagamentobloqueto
                  left join tribpagamentobloqueto         tpb  on tpb.idpagamentobloqueto  = atcp.idpagamentobloqueto
                  left join tribpagamento                 tpag on tpag.entidade = tpb.entidade and tpag.exerciciopagamento = tpb.exerciciopagamento and tpag.pagamento = tpb.pagamento
                  left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = atcp.iddebitoparcelareceita
                  left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = atcp.iddebitoparcelareceita
         where tpag.entidade = :entidade and tpag.datalancamento BETWEEN :dataInicial AND :dataFinal
         union all
         select atc.idtcearrtipocredito,
                atc.nrAnoArrecadacao,
                atc.idTipoOrigemReceita,
                atc.idTipoArrecadacao,
                atc.idTipoCredito,
                case when (atc.idTipoOrigemReceita = 1) then atc.nrcredito else null end as nrCredito,
                case when (atc.idTipoOrigemReceita = 1) then atc.nranocredito else null end as nranocredito,
                case when (atc.idTipoOrigemReceita = 2) then atc.nrdivida else null end as nrdivida,
                case when (atc.idTipoOrigemReceita = 2) then atc.nranodivida else null end as nranodivida,
                atc.nrMes,
                atc.nrAno,
                atcc.valor as valor
         from tceArrecadacaoTipoCredito          atc
                  left join tceArrTipoCreditoCredito      atcc on atcc.idtcearrtipocredito = atc.idtcearrtipocredito
                  left join tribCreditoContribuinteItem   tcci on tcci.idcreditocontribuinteitem = atcc.idcreditocontribuinteitem and tcci.iddebitoparcelareceita = atcc.iddebitoparcelareceita
                  left join tribcreditocontribuinte       tcc  on tcc.entidade = tcci.entidade and tcc.exercicio = tcci.exercicio and tcc.creditocontribuinte = tcci.creditocontribuinte
                  left join tribdebitoparcelareceita      tdpr on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
                  left join tribdebitoparcela             tdp  on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio and tdp.tipocadastro = tdpr.tipocadastro
             and tdp.cadastrogeral = tdpr.cadastrogeral and tdp.guiarecolhimento = tdpr.guiarecolhimento
             and tdp.subdivida = tdpr.subdivida and tdp.parcela = tdpr.parcela
                  left join tcedebitolanccredito          tdlc on tdlc.iddebitoparcelareceita = atcc.iddebitoparcelareceita
                  left join (select distinct a.idtceinsccreditoda, a.iddebitoparcelareceita from tcedebitoinsccreditoda a) tdic on tdic.iddebitoparcelareceita = atcc.iddebitoparcelareceita
         where tcc.entidade = :entidade and tcc.data between :dataInicial and :dataFinal
         union all
         SELECT
             atc.idtcearrtipocredito,
             atc.nrAnoArrecadacao,
             atc.idTipoOrigemReceita,
             atc.idTipoArrecadacao,
             tlc.idtipocredito,
             case when (atc.idTipoOrigemReceita = 1) then atc.nrcredito else null end as nrCredito,
             case when (atc.idTipoOrigemReceita = 1) then atc.nranocredito else null end as nranocredito,
             case when (atc.idTipoOrigemReceita = 2) then atc.nrdivida else null end as nrdivida,
             case when (atc.idTipoOrigemReceita = 2) then atc.nranodivida else null end as nranodivida,
             atc.nrMes,
             atc.nrAno,
             trc.valor as valor
         from tceRetencaoContabil trc
                  join tcearrtipocreditoretencao rlc on trc.idretencaocontabil = rlc.idretencaocontabil
                  join tcearrecadacaotipocredito atc on rlc.idtcearrtipocredito = atc.idtcearrtipocredito
                  join tcearrecadacaotipocredito tlc on rlc.idtcearrtipocredito = tlc.idtipocredito
         where (trc.dtlancamento BETWEEN :dataInicial AND :dataFinal)
           and not exists (
             select 1 from tcearrtipocreditoretencao tatcr
             where tatcr.idretencaocontabil = trc.idRetencaoContabil
         )
     ) x
group by x.idtcearrtipocredito,
         x.nrAnoArrecadacao,
         x.idTipoOrigemReceita,
         x.idTipoArrecadacao,
         x.nrCredito,
         x.nranocredito,
         x.nrdivida,
         x.nranodivida,
         x.nrMes,
         x.nrAno,
         x.idTipoCredito
order by 2,1