select filtro.DataMovimentacao,
       sum(filtro.iptuex) as iptuex,
       sum(filtro.issex) as issex,
       sum(filtro.itbiex) as issex,
       sum(filtro.melhoriaex) as issex,
       sum(filtro.taxasex) as issex,
       sum(filtro.outrosex) as outrosex,
       sum(filtro.cosipex) as cosipex,
       sum(filtro.impugnacaoex) as impugnacaoex,
       sum(filtro.naotribex) as naotribex,
       sum(filtro.iptuda) as iptuda,
       sum(filtro.issda) as issda,
       sum(filtro.itbida) as itbida,
       sum(filtro.melhoriada) as melhoriada,
       sum(filtro.taxasda) as taxasda,
       sum(filtro.outrosda) as outrosda,
       sum(filtro.cosipda) as cosipda,
       sum(filtro.impugnacaoda) as impugnacaod,
       sum(filtro.naotribda) as naotribda,
       sum(filtro.iptu) as iptu,
       sum(filtro.iss) as iss,
       sum(filtro.itbi) as itbi,
       sum(filtro.melhoria) as melhoria,
       sum(filtro.taxas) as taxas,
       sum(filtro.outros) as outros,
       sum(filtro.cosip) as cosip,
       sum(filtro.impugnacao) as impugnacao,
       sum(filtro.naotrib) as naotrib,
       sum(filtro.SimplesNacional) as SimplesNacional
from
    (
-- Pagamento
Select pg.DataMovimentacao,
       sum(coalesce(pg.iptuex,0)) as iptuex,
       sum(coalesce(pg.issex,0)) as issex,
       sum(coalesce(pg.itbiex,0)) as itbiex,
       sum(coalesce(pg.melhoriaex,0)) as melhoriaex,
       sum(coalesce(pg.taxasex,0)) as taxasex,
       sum(coalesce(pg.outrosex,0)) as outrosex,
       sum(coalesce(pg.cosipex,0)) as cosipex,
       sum(coalesce(pg.impugnacaoex,0)) impugnacaoex,
       sum(coalesce(pg.naotribex,0)) as naotribex,
       sum(coalesce(pg.iptuda,0)) as iptuda,
       sum(coalesce(pg.issda,0)) as issda,
       sum(coalesce(pg.itbida,0)) as itbida,
       sum(coalesce(pg.melhoriada,0)) as melhoriada,
       sum(coalesce(pg.taxasda,0)) as taxasda,
       sum(coalesce(pg.outrosda,0)) as outrosda,
       sum(coalesce(pg.cosipda,0)) as cosipda,
       sum(coalesce(pg.impugnacaoda,0)) impugnacaoda,
       sum(coalesce(pg.naotribda,0)) as naotribda,
       sum(coalesce(pg.iptu,0)) as iptu,
       sum(coalesce(pg.iss,0)) as iss,
       sum(coalesce(pg.itbi,0)) as itbi,
       sum(coalesce(pg.melhoria,0)) as melhoria,
       sum(coalesce(pg.taxas,0)) as taxas,
       sum(coalesce(pg.outros,0)) as outros,
       sum(coalesce(pg.cosip,0)) as cosip,
       sum(coalesce(pg.impugnacao,0)) impugnacao,
       sum(coalesce(pg.naotrib,0)) as naotrib,
       sum(coalesce(pg.SimplesNacional,0)) as simplesnacional
from (
Select tp.dataLancamento as DataMovimentacao,
       tpd.SituacaoLegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as naotrib,
       sum(case when tp.simplesnacional = 'S' and tr.tiporeceita = 2 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as SimplesNacional
from tribpagamentodebito tpd
  left join tribpagamentobloqueto tpb on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
  left join tribpagamento tp on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento and tpb.pagamento = tp.pagamento
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
  left join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
  left join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
where tp.entidade = :entidade
  and tp.datalancamento  between ':dataInicial' AND ':dataFinal'
group by
  tp.dataLancamento,
  tpd.SituacaoLegal,
  tr.TipoReceita,
  tp.simplesnacional
) pg
group by pg.DataMovimentacao
union all
-- Reabilitação Pagamento
Select pg.DataMovimentacao,
       sum(coalesce(pg.iptuex,0)) as iptuex,
       sum(coalesce(pg.issex,0)) as issex,
       sum(coalesce(pg.itbiex,0)) as itbiex,
       sum(coalesce(pg.melhoriaex,0)) as melhoriaex,
       sum(coalesce(pg.taxasex,0)) as taxasex,
       sum(coalesce(pg.outrosex,0)) as outrosex,
       sum(coalesce(pg.cosipex,0)) as cosipex,
       sum(coalesce(pg.impugnacaoex,0)) impugnacaoex,
       sum(coalesce(pg.naotribex,0)) as naotribex,
       sum(coalesce(pg.iptuda,0)) as iptuda,
       sum(coalesce(pg.issda,0)) as issda,
       sum(coalesce(pg.itbida,0)) as itbida,
       sum(coalesce(pg.melhoriada,0)) as melhoriada,
       sum(coalesce(pg.taxasda,0)) as taxasda,
       sum(coalesce(pg.outrosda,0)) as outrosda,
       sum(coalesce(pg.cosipda,0)) as cosipda,
       sum(coalesce(pg.impugnacaoda,0)) impugnacaoda,
       sum(coalesce(pg.naotribda,0)) as naotribda,
       sum(coalesce(pg.iptu,0)) as iptu,
       sum(coalesce(pg.iss,0)) as iss,
       sum(coalesce(pg.itbi,0)) as itbi,
       sum(coalesce(pg.melhoria,0)) as melhoria,
       sum(coalesce(pg.taxas,0)) as taxas,
       sum(coalesce(pg.outros,0)) as outros,
       sum(coalesce(pg.cosip,0)) as cosip,
       sum(coalesce(pg.impugnacao,0)) impugnacao,
       sum(coalesce(pg.naotrib,0)) as naotrib,
       sum(coalesce(pg.SimplesNacional,0)) as simplesnacional
from (
Select tp.dataLancamento as DataMovimentacao,
       tpd.SituacaoLegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as naotrib,
       sum(case when tp.simplesnacional = 'S' and tr.tiporeceita = 2 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) as SimplesNacional
from tribpagamentodebito tpd
  left join tribpagamentobloqueto tpb on tpd.idpagamentobloqueto = tpb.idpagamentobloqueto
  left join tribpagamento tp on tpb.entidade = tp.entidade and tpb.exerciciopagamento = tp.exerciciopagamento AND tpb.pagamento = tp.pagamento
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tpd.iddebitoparcelareceita
  left join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
  left join tribreceitatipo trt   ON trt.tiporeceita = tr.tiporeceita
  left join contabancaria cb  on cb.entidade = tp.entidade and cb.contabancaria = tp.contabancaria
  join tribestornopagamento tep on tep.entidade = tp.entidade and tep.exerciciopagamento = tp.exerciciopagamento and tep.pagamento = tp.pagamento
where tp.entidade = :entidade
  and tep.datareabilitacao is not null
  and tep.datareabilitacao between ':dataInicial' AND ':dataFinal'
  and tep.datareabilitacao <> tep.data
group by
  tp.datalancamento,
  tpd.situacaolegal,
  tr.tipoReceita,
  tp.simplesnacional
) pg
group by pg.DataMovimentacao
union ALL
-- Crédito de Contribuinte
Select pg.DataMovimentacao,
       sum(coalesce(pg.iptuex,0)) as iptuex,
       sum(coalesce(pg.issex,0)) as issex,
       sum(coalesce(pg.itbiex,0)) as itbiex,
       sum(coalesce(pg.melhoriaex,0)) as melhoriaex,
       sum(coalesce(pg.taxasex,0)) as taxasex,
       sum(coalesce(pg.outrosex,0)) as outrosex,
       sum(coalesce(pg.cosipex,0)) as cosipex,
       sum(coalesce(pg.impugnacaoex,0)) impugnacaoex,
       sum(coalesce(pg.naotribex,0)) as naotribex,
       sum(coalesce(pg.iptuda,0)) as iptuda,
       sum(coalesce(pg.issda,0)) as issda,
       sum(coalesce(pg.itbida,0)) as itbida,
       sum(coalesce(pg.melhoriada,0)) as melhoriada,
       sum(coalesce(pg.taxasda,0)) as taxasda,
       sum(coalesce(pg.outrosda,0)) as outrosda,
       sum(coalesce(pg.cosipda,0)) as cosipda,
       sum(coalesce(pg.impugnacaoda,0)) impugnacaoda,
       sum(coalesce(pg.naotribda,0)) as naotribda,
       sum(coalesce(pg.iptu,0)) as iptu,
       sum(coalesce(pg.iss,0)) as iss,
       sum(coalesce(pg.itbi,0)) as itbi,
       sum(coalesce(pg.melhoria,0)) as melhoria,
       sum(coalesce(pg.taxas,0)) as taxas,
       sum(coalesce(pg.outros,0)) as outros,
       sum(coalesce(pg.cosip,0)) as cosip,
       sum(coalesce(pg.impugnacao,0)) impugnacao,
       sum(coalesce(pg.naotrib,0)) as naotrib,
       sum(coalesce(pg.SimplesNacional,0)) as simplesnacional
from (
Select tcc.data as DataMovimentacao,
       tdp.situacaolegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal = 0 then coalesce(tcci.valorlancado,0) else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal = 0 then coalesce(tcci.valorlancado,0) else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal = 0 then coalesce(tcci.valorlancado,0) else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal = 0 then coalesce(tcci.valorlancado,0) else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal = 0 then coalesce(tcci.valorlancado,0) else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal = 0 then coalesce(tcci.valorlancado,0) else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal = 0 then coalesce(tcci.valorlancado,0) else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal = 0 then coalesce(tcci.valorlancado,0) else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorlancado,0) else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then coalesce(tcci.valorlancado,0) else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then coalesce(tcci.valorlancado,0) else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then coalesce(tcci.valorlancado,0) else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then coalesce(tcci.valorlancado,0) else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then coalesce(tcci.valorlancado,0) else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then coalesce(tcci.valorlancado,0) else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then coalesce(tcci.valorlancado,0) else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then coalesce(tcci.valorlancado,0) else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then coalesce(tcci.valorlancado,0) else 0 end) as naotrib,
       0 as SimplesNacional
from tribcreditocontribuinte tcc
  left outer join tribcreditocontribuinteitem tcci on tcci.entidade = tcc.entidade  and tcci.exercicio = tcc.exercicio and tcci.creditocontribuinte  = tcc.creditocontribuinte
  left outer join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita  = tcci.iddebitoparcelareceita
  left outer join tribdebitoparcela tdp on tdp.entidade  = tdpr.entidade
    and tdp.exercicio = tdpr.exercicio
    and tdp.tipocadastro = tdpr.tipocadastro
    and tdp.cadastrogeral  = tdpr.cadastrogeral
    and tdp.guiarecolhimento  = tdpr.guiarecolhimento
    and tdp.subdivida  = tdpr.subdivida
    and tdp.parcela = tdpr.parcela
  left join tribreceita tr on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
       join contabancaria cb  on cb.entidade = tcc.entidade and cb.contabancaria = tcc.contabancaria
where tcc.entidade = :entidade
  and tcc.data BETWEEN ':dataInicial' AND ':dataFinal'
group by
  tcc.data,
  tdp.situacaolegal,
  tr.tiporeceita
) pg
group by pg.DataMovimentacao
union all
-- Devolucao de credito
Select pg.DataMovimentacao,
       sum(coalesce(pg.iptuex,0)) as iptuex,
       sum(coalesce(pg.issex,0)) as issex,
       sum(coalesce(pg.itbiex,0)) as itbiex,
       sum(coalesce(pg.melhoriaex,0)) as melhoriaex,
       sum(coalesce(pg.taxasex,0)) as taxasex,
       sum(coalesce(pg.outrosex,0)) as outrosex,
       sum(coalesce(pg.cosipex,0)) as cosipex,
       sum(coalesce(pg.impugnacaoex,0)) impugnacaoex,
       sum(coalesce(pg.naotribex,0)) as naotribex,
       sum(coalesce(pg.iptuda,0)) as iptuda,
       sum(coalesce(pg.issda,0)) as issda,
       sum(coalesce(pg.itbida,0)) as itbida,
       sum(coalesce(pg.melhoriada,0)) as melhoriada,
       sum(coalesce(pg.taxasda,0)) as taxasda,
       sum(coalesce(pg.outrosda,0)) as outrosda,
       sum(coalesce(pg.cosipda,0)) as cosipda,
       sum(coalesce(pg.impugnacaoda,0)) impugnacaoda,
       sum(coalesce(pg.naotribda,0)) as naotribda,
       sum(coalesce(pg.iptu,0)) as iptu,
       sum(coalesce(pg.iss,0)) as iss,
       sum(coalesce(pg.itbi,0)) as itbi,
       sum(coalesce(pg.melhoria,0)) as melhoria,
       sum(coalesce(pg.taxas,0)) as taxas,
       sum(coalesce(pg.outros,0)) as outros,
       sum(coalesce(pg.cosip,0)) as cosip,
       sum(coalesce(pg.impugnacao,0)) impugnacao,
       sum(coalesce(pg.naotrib,0)) as naotrib,
       sum(coalesce(pg.SimplesNacional,0)) as simplesnacional
from (
Select d.data as DataMovimentacao,
       tdp.situacaolegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal = 0 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal = 0 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal = 0 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal = 0 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal = 0 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal = 0 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal = 0 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal = 0 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then coalesce(dd.valordevolvido,0) * -1 else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then coalesce(dd.valordevolvido,0) * -1 else 0 end) as naotrib,
       0 as SimplesNacional
from tribDevolucaoCredito            d
  LEFT join tribDevolucaoCreditoItem     di   on di.iddevolucaocredito = d.iddevolucaocredito
                 left join tribDevolucaoCreditoDebito   dd   on dd.iddevolucaocredito = di.iddevolucaocredito and dd.sequenciaitem = di.sequenciaitem
                 left join tribDebitoParcelaReceita     tdpr on dd.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
                 left join tribdebitoparcela            tdp  on tdp.entidade  = tdpr.entidade and tdp.exercicio = tdpr.exercicio
                                                           and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral  = tdpr.cadastrogeral
                                                           and tdp.guiarecolhimento  = tdpr.guiarecolhimento and tdp.subdivida  = tdpr.subdivida
                                                           and tdp.parcela = tdpr.parcela
                 left join tribreceita                  tr   on tr.entidade = tdpr.entidade and tr.exercicio = tdpr.exercicio and tr.receita = tdpr.receita
                 join contabancaria                cb   on cb.entidade = d.entidade and cb.contabancaria = d.contabancaria
where d.entidade = :entidade
          and d.data between ':dataInicial' AND ':dataFinal'
group by
   d.data,
   tdp.situacaolegal,
   tr.tiporeceita
) pg
group by pg.DataMovimentacao
union all
--Estorno de Pagamento
Select pg.DataMovimentacao,
       sum(coalesce(pg.iptuex,0)) as iptuex,
       sum(coalesce(pg.issex,0)) as issex,
       sum(coalesce(pg.itbiex,0)) as itbiex,
       sum(coalesce(pg.melhoriaex,0)) as melhoriaex,
       sum(coalesce(pg.taxasex,0)) as taxasex,
       sum(coalesce(pg.outrosex,0)) as outrosex,
       sum(coalesce(pg.cosipex,0)) as cosipex,
       sum(coalesce(pg.impugnacaoex,0)) impugnacaoex,
       sum(coalesce(pg.naotribex,0)) as naotribex,
       sum(coalesce(pg.iptuda,0)) as iptuda,
       sum(coalesce(pg.issda,0)) as issda,
       sum(coalesce(pg.itbida,0)) as itbida,
       sum(coalesce(pg.melhoriada,0)) as melhoriada,
       sum(coalesce(pg.taxasda,0)) as taxasda,
       sum(coalesce(pg.outrosda,0)) as outrosda,
       sum(coalesce(pg.cosipda,0)) as cosipda,
       sum(coalesce(pg.impugnacaoda,0)) impugnacaoda,
       sum(coalesce(pg.naotribda,0)) as naotribda,
       sum(coalesce(pg.iptu,0)) as iptu,
       sum(coalesce(pg.iss,0)) as iss,
       sum(coalesce(pg.itbi,0)) as itbi,
       sum(coalesce(pg.melhoria,0)) as melhoria,
       sum(coalesce(pg.taxas,0)) as taxas,
       sum(coalesce(pg.outros,0)) as outros,
       sum(coalesce(pg.cosip,0)) as cosip,
       sum(coalesce(pg.impugnacao,0)) impugnacao,
       sum(coalesce(pg.naotrib,0)) as naotrib,
       sum(coalesce(pg.SimplesNacional,0)) as simplesnacional
from (
Select tep.data as DataMovimentacao,
       tpd.situacaolegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal = 0 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal = 0 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal = 0 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal = 0 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal = 0 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal = 0 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal = 0 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal = 0 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tpd.situacaolegal in (1,2) then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then (coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0)) * -1 else 0 end) as naotrib,
       sum(case when tp.simplesnacional = 'S' and tr.tiporeceita = 2 and tpd.situacaolegal = 0 then coalesce(tpd.valorpago,0) + coalesce(tpd.valorpagomaior,0) else 0 end) * -1 as SimplesNacional
from tribestornopagamento tep
  left join tribestornopagamentoitem tepi
    on tepi.entidade = tep.entidade and tepi.exercicio = tep.exercicio and tepi.estorno = tep.estorno
  left join tribpagamentodebito tpd
    on tpd.idpagamentobloqueto = tepi.idpagamentobloqueto
   AND tpd.iddebitoparcelareceita = tepi.iddebitoparcelareceita
  left join tribpagamentobloqueto tpb
    on tpb.idpagamentobloqueto = tpd.idpagamentobloqueto
  left join tribpagamento tp
    on tp.entidade = tpb.entidade
    and tp.exerciciopagamento = tpb.exerciciopagamento
    and tp.pagamento = tpb.pagamento
  LEFT join contabancaria cb
    on tep.entidade = cb.entidade and tep.contabancariaestorno = cb.contabancaria
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tpd.iddebitoparcelareceita
  left join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio and tr.entidade = tdpr.entidade
where tep.entidade = :entidade
  and tep.data BETWEEN ':dataInicial' AND ':dataFinal'
  and (tep.datareabilitacao is null or (tep.datareabilitacao is not null and tep.data <> tep.datareabilitacao))
group by
   tep.data,
   tpd.situacaolegal,
   tr.tiporeceita,
   tp.simplesnacional
) pg
group by pg.DataMovimentacao
union ALL
--Estorno de Crédito de Contribuinte
Select pg.DataMovimentacao,
       sum(coalesce(pg.iptuex,0)) as iptuex,
       sum(coalesce(pg.issex,0)) as issex,
       sum(coalesce(pg.itbiex,0)) as itbiex,
       sum(coalesce(pg.melhoriaex,0)) as melhoriaex,
       sum(coalesce(pg.taxasex,0)) as taxasex,
       sum(coalesce(pg.outrosex,0)) as outrosex,
       sum(coalesce(pg.cosipex,0)) as cosipex,
       sum(coalesce(pg.impugnacaoex,0)) impugnacaoex,
       sum(coalesce(pg.naotribex,0)) as naotribex,
       sum(coalesce(pg.iptuda,0)) as iptuda,
       sum(coalesce(pg.issda,0)) as issda,
       sum(coalesce(pg.itbida,0)) as itbida,
       sum(coalesce(pg.melhoriada,0)) as melhoriada,
       sum(coalesce(pg.taxasda,0)) as taxasda,
       sum(coalesce(pg.outrosda,0)) as outrosda,
       sum(coalesce(pg.cosipda,0)) as cosipda,
       sum(coalesce(pg.impugnacaoda,0)) impugnacaoda,
       sum(coalesce(pg.naotribda,0)) as naotribda,
       sum(coalesce(pg.iptu,0)) as iptu,
       sum(coalesce(pg.iss,0)) as iss,
       sum(coalesce(pg.itbi,0)) as itbi,
       sum(coalesce(pg.melhoria,0)) as melhoria,
       sum(coalesce(pg.taxas,0)) as taxas,
       sum(coalesce(pg.outros,0)) as outros,
       sum(coalesce(pg.cosip,0)) as cosip,
       sum(coalesce(pg.impugnacao,0)) impugnacao,
       sum(coalesce(pg.naotrib,0)) as naotrib,
       sum(coalesce(pg.SimplesNacional,0)) as simplesnacional
from (
Select tcc.dataestorno as DataMovimentacao,
       tdp.situacaolegal,
       tr.TipoReceita,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal = 0 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as iptuex,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal = 0 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as issex,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal = 0 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as itbiex,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal = 0 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as melhoriaex,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal = 0 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as taxasex,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal = 0 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as outrosex,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal = 0 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as cosipex,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal = 0 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as impugnacaoex,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as naotribex,
       sum(case when tr.tiporeceita = 1 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as iptuda,
       sum(case when tr.tiporeceita = 2 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as issda,
       sum(case when tr.tiporeceita = 3 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as itbida,
       sum(case when tr.tiporeceita = 4 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as melhoriada,
       sum(case when tr.tiporeceita = 5 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as taxasda,
       sum(case when tr.tiporeceita = 6 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as outrosda,
       sum(case when tr.tiporeceita = 7 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as cosipda,
       sum(case when tr.tiporeceita = 8 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as impugnacaoda,
       sum(case when tr.tiporeceita = 9 and tdp.situacaolegal in (1,2) then coalesce(tcci.valorestornado,0) * -1 else 0 end) as naotribda,
       sum(case when tr.tiporeceita = 1 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as iptu,
       sum(case when tr.tiporeceita = 2 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as iss,
       sum(case when tr.tiporeceita = 3 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as itbi,
       sum(case when tr.tiporeceita = 4 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as melhoria,
       sum(case when tr.tiporeceita = 5 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as taxas,
       sum(case when tr.tiporeceita = 6 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as outros,
       sum(case when tr.tiporeceita = 7 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as cosip,
       sum(case when tr.tiporeceita = 8 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as impugnacao,
       sum(case when tr.tiporeceita = 9 then coalesce(tcci.valorestornado,0) * -1 else 0 end) as naotrib,
       0.00 AS SimplesNacional
from tribcreditocontribuinte tcc
  left join tribCreditoContribuinteItem tcci
     on tcci.entidade = tcc.entidade and tcci.exercicio = tcc.exercicio
     and tcci.creditocontribuinte = tcc.creditocontribuinte
  left join contabancaria cb on tcc.entidade = cb.entidade and tcc.contabancariaestorno = cb.contabancaria
  left join tribdebitoparcelareceita tdpr on tdpr.iddebitoparcelareceita = tcci.iddebitoparcelareceita
  left join tribdebitoparcela            tdp
     on tdp.entidade  = tdpr.entidade
     and tdp.exercicio = tdpr.exercicio
    and tdp.tipocadastro = tdpr.tipocadastro
    and tdp.cadastrogeral  = tdpr.cadastrogeral
    and tdp.guiarecolhimento  = tdpr.guiarecolhimento
    and tdp.subdivida  = tdpr.subdivida
    and tdp.parcela = tdpr.parcela
  left join tribreceita tr on tr.receita = tdpr.receita and tr.exercicio = tdpr.exercicio and tr.entidade = tdpr.entidade
where tcc.entidade = :entidade
  and tcc.dataestorno BETWEEN ':dataInicial' AND ':dataFinal'
  and tcc.valorestornado > 0
GROUP BY
   tcc.dataestorno,
   tdp.situacaolegal,
   tr.tiporeceita
) pg
group by pg.DataMovimentacao
) as filtro
group by filtro.DataMovimentacao
order by filtro.DataMovimentacao
