select
		       TP.ENTIDADE,
		       TP.DATABAIXA,
		       tdpr.Exercicio,
		       CASE WHEN (tdpr.GUIARECOLHIMENTO = 62) AND
		                 (tp.MESREFERENCIA IS NULL) AND
		                 (tpb.CODIGOBARRASEXTERNO IS NULL) AND
		                 (TBAD.MESMOVIMENTO IS NULL) THEN
		                   CASE WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1 THEN tdpr.EXERCICIO - 1
		                   ELSE tdpr.EXERCICIO END
		       else tdpr.EXERCICIO END AS EXERCICIOREFERENCIA,
		       '01' AS TIPOPAGTO,
		       tdpr.TipoCadastro,
		       tdpr.CadastroGeral,
		       tdpr.GuiaRecolhimento,
		       tdpr.SubDivida,
		       tdpr.Parcela AS PARCELAORIGINAL,
		       CASE WHEN TP.PARCELAANTERIOR IS NOT NULL THEN
		         TP.PARCELAANTERIOR
		       ELSE TDPR.PARCELA END AS PARCELA,
		       tp.ExercicioLote,
		       CASE WHEN TP.LOTEPREF IS NULL THEN
		         TP.LOTE
		       ELSE TP.LOTEPREF END AS LOTE,
		       TP.LOTEPREF,
		       CASE WHEN TP.LOTEPREF IS NULL THEN
		         TBAD.SEQUENCIAARQUIVO
		       ELSE TP.SEQUENCIAPREF END AS SEQUENCIALOTE,
		       TP.DataPagamento,
		       TP.DATALANCAMENTO AS DATAMOVIMENTO,
		       TPD.SITUACAOLEGAL AS SITUACAOBAIXA,
		       tp.ContaBancaria,
		       cb.Descricao ContaBancaria_Descr,
		       tp.banco,
		       cb.agencia,
		       tp.ocorrencia,
		       tb.Tipobloqueto,
		       tb.nossonumero,
		       tb.CODIGOBARRASEXTERNO as CodigoBarras,
		       TD.PARCELADO AS TIPODEBITO,
		       TAIF.AUTOINFRACAOFISCAL,
		       TAIF.EXERCICIO AS EXERCICIOAUTOINFRACAO,
		       CASE WHEN TPL.TIPOARQUIVO = 3 THEN 'S'
		            WHEN TPL.TIPOARQUIVO = 5 THEN 'R'
		       ELSE ' ' END AS TIPODOCUMENTO,
		       COMPLETASTRING((CASE WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 101) THEN '01'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 102) THEN '02'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 103) THEN '03'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 104) THEN '04'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 105) THEN '05'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 106) THEN '06'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 107) THEN '07'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 108) THEN '08'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 109) THEN '09'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 110) THEN '10'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 111) THEN '11'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 112) THEN '12'
		            WHEN tdpr.GUIARECOLHIMENTO IN (41, 91, 93, 94) THEN
		              CASE WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1 THEN '12'
		              ELSE CAST((EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) - 1) AS VARCHAR(2)) END
		            WHEN (tdpr.GUIARECOLHIMENTO = 92) THEN ''
		            WHEN tdpr.GUIARECOLHIMENTO = 62 THEN
		              CASE WHEN tp.MESREFERENCIA IS NOT NULL THEN CAST(tp.MESREFERENCIA AS VARCHAR(2))
		                   WHEN TP.MESREFERENCIA IS NOT NULL THEN CAST(TP.MESREFERENCIA AS VARCHAR(2))
		                   WHEN tdp.MESREFERENCIA IS NOT NULL THEN CAST(tdp.MESREFERENCIA AS VARCHAR(2))
		                   WHEN tb.CODIGOBARRASEXTERNO IS NOT NULL THEN substring(tb.CODIGOBARRASEXTERNO, 31, 2)
		                   WHEN TBAD.MESMOVIMENTO IS NOT NULL THEN CAST(TBAD.MESMOVIMENTO AS VARCHAR(2))
		              ELSE
		                CASE WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1 THEN '12'
		                 ELSE CAST((EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) - 1) AS VARCHAR(2)) END
		       END END),'0','E','2') AS MESREFERENCIA,
		       CASE WHEN (tp.LOTEPREF IS NULL) THEN 'A'
		       ELSE 'N' END AS SISTEMAGERACAO,
		       CASE WHEN TP.EXERCICIOPAGAMENTO IS NOT NULL THEN
		         COMPLETASTRING(CAST(TP.ENTIDADE AS VARCHAR(2)), '0', 'E', 2) || TP.EXERCICIOPAGAMENTO || COMPLETASTRING(CAST(TP.PAGAMENTO AS VARCHAR(10)), '0', 'E', 10) || COMPLETASTRING(substring(CAST(TDPR.EXERCICIO AS VARCHAR(4)), 3, 2), '0', 'E', 2) || COMPLETASTRING(CAST(TDPR.TIPOCADASTRO AS VARCHAR(2)), '0', 'E', 2) || COMPLETASTRING(CAST(TDPR.CADASTROGERAL AS VARCHAR(8)), '0', 'E', 10) || COMPLETASTRING(CAST(TDPR.GUIARECOLHIMENTO AS VARCHAR(3)), '0', 'E', 3) || COMPLETASTRING(CAST(CASE WHEN TDPR.SUBDIVIDA >= 1000 THEN 999 ELSE TDPR.SUBDIVIDA END  AS VARCHAR(3)), '0', 'E', 3) || COMPLETASTRING(CAST(TDPR.PARCELA AS VARCHAR(4)), '0', 'E', 4)
		       ELSE '' END as CHAVEPAGAMENTOAISE,
		       substring(TBAD.DETALHE,462,17) AS CODIGODAS,
		       substring(tb.CODIGOBARRASEXTERNO,28,17) as CodigoGuiaISSe,
		       SUM(TPD.VALORPAGO) AS VALORPAGO,
		       SUM(TPD.VALORPRINCIPAL) AS VALORPRINCIPAL,
		       SUM(TPD.VALORMULTA) AS VALORMULTA,
		       SUM(TPD.VALORJUROS) AS VALORJUROS,
		       SUM(TPD.VALORCORRECAO) AS VALORCORRECAO
		from tribPagamento tp
		   Left outer join Tribpagamentolote tpl on
		        tpl.entidade = tp.entidade and
		        tpl.exercicio = tp.exerciciolote and
		        tpl.lote = tp.lote
		   Left outer join tribPagamentoBloqueto tpb
		       on tpb.Entidade = tp.Entidade
		      and tpb.ExercicioPagamento = tp.Exerciciopagamento
		      and tpb.Pagamento = tp.Pagamento
		   Left outer join TribBloqueto tb
		     on tb.Entidade = tpb.Entidade
		    and tb.Exerciciobloqueto = tpb.Exerciciobloqueto
		    and tb.Bloqueto = tpb.Bloqueto
		   Left outer join tribPagamentoDebito tpd
		       on tpd.IdPagamentoBloqueto = tpb.IdPagamentoBloqueto
		   Left outer join TribDebitoParcelaReceita tdpr
		       on tdpr.IdDebitoParcelaReceita = tpd.IdDebitoParcelaReceita
		   Left outer join tribDebitoParcela tdp on
		       tdp.entidade = tdpr.entidade and
		       tdp.exercicio = tdpr.exercicio and
		       tdp.tipocadastro = tdpr.tipocadastro and
		       tdp.cadastrogeral = tdpr.cadastrogeral and
		       tdp.guiarecolhimento = tdpr.guiarecolhimento and
		       tdp.subdivida = tdpr.subdivida and
		       tdp.parcela = tdpr.parcela
		   Left outer join ContaBancaria cb
		       on cb.Entidade = tp.Entidade
		      and cb.ContaBancaria = tp.ContaBancaria
		   LEFT OUTER JOIN TRIBAUTOINFRACAODEBITO TAID
		            ON TAID.ENTIDADE = TDp.ENTIDADE
		           AND TAID.EXERCICIO = TDp.EXERCICIO
		           AND TAID.TIPOCADASTRO = TDp.TIPOCADASTRO
		           AND TAID.CADASTROGERAL = TDp.CADASTROGERAL
		           AND TAID.GUIARECOLHIMENTO = TDp.GUIARECOLHIMENTO
		           AND TAID.SUBDIVIDA = TDp.SUBDIVIDA
		   LEFT OUTER JOIN TRIBAUTOINFRACAOFISCAL TAIF
		            ON TAIF.IDAUTOINFRACAOFISCAL = TAID.IDAUTOINFRACAOFISCAL
		   LEFT OUTER JOIN TRIBBAIXAAUTOMATICADETALHE TBAD
		            ON TBAD.ENTIDADE = TP.ENTIDADE
		           AND TBAD.EXERCICIO = TP.EXERCICIOLOTE
		           AND TBAD.LOTE = TP.LOTE
		           AND TBAD.EXERCICIOPAGAMENTO = TP.EXERCICIOPAGAMENTO
		           AND TBAD.PAGAMENTO = TP.PAGAMENTO
		   LEFT OUTER JOIN TRIBDEBITO TD ON
		          tdp.entidade = td.entidade and
		          tdp.exercicio = td.exercicio and
		          tdp.tipocadastro = td.tipocadastro and
		          tdp.cadastrogeral = td.cadastrogeral and
		          tdp.guiarecolhimento = td.guiarecolhimento and
		          tdp.subdivida = td.subdivida
		   LEFT OUTER JOIN TRIBCADASTROGERAL TCG ON
		         td.TipoCadastro = tcg.TipoCadastro and
		         td.CadastroGeral = tcg.CadastroGeral
		   :filtropagamentos
		      AND TD.GUIARECOLHIMENTO IN (3, 5, 6, 7, 8, 9, 10, 15, 16, 17, 18, 23, 24, 26, 27, 28, 29, 30 ,31, 33, 35, 36, 37, 41, 44, 45, 49, 56, 62, 91, 92, 93, 94, 98, 101, 105, 132,152,100,149)
		      AND NOT EXISTS(
		          SELECT SUM(TD_ISENCAO.VALORRECEITA), SUM(TD_ISENCAO.VALORRENUNCIA) FROM TRIBDEBITORECEITA TD_ISENCAO
		          WHERE TD_ISENCAO.ENTIDADE = TDP.ENTIDADE
		          AND  TD_ISENCAO.EXERCICIO = TDP.EXERCICIO
		          AND  TD_ISENCAO.TIPOCADASTRO = TDP.TIPOCADASTRO
		          AND  TD_ISENCAO.CADASTROGERAL = TDP.CADASTROGERAL
		          AND  TD_ISENCAO.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO
		          AND  TD_ISENCAO.SUBDIVIDA = TDP.SUBDIVIDA
		         HAVING (SUM(TD_ISENCAO.VALORRECEITA) - SUM(TD_ISENCAO.VALORRENUNCIA) = 0)
		            AND NOT (SUM(TD_ISENCAO.VALORRECEITA) = 0 AND SUM(TD_ISENCAO.VALORRENUNCIA) = 0))
		group by
		       TP.ENTIDADE,
		       TP.DATABAIXA,
		       tdpr.Exercicio,
		       CASE WHEN (tdpr.GUIARECOLHIMENTO = 62) AND
		                 (tp.MESREFERENCIA IS NULL) AND
		                 (tpb.CODIGOBARRASEXTERNO IS NULL) AND
		                 (TBAD.MESMOVIMENTO IS NULL) THEN
		                   CASE WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1 THEN tdpr.EXERCICIO - 1
		                   ELSE tdpr.EXERCICIO END
		       else tdpr.EXERCICIO END,
		       tdpr.TipoCadastro,
		       tdpr.CadastroGeral,
		       tdpr.GuiaRecolhimento,
		       tdpr.SubDivida,
		       tdpr.Parcela,
		       CASE WHEN TP.PARCELAANTERIOR IS NOT NULL THEN
		         TP.PARCELAANTERIOR
		       ELSE TDPR.PARCELA END,
		       tp.ExercicioLote,
		       CASE WHEN TP.LOTEPREF IS NULL THEN
		         TP.LOTE
		       ELSE TP.LOTEPREF END,
		       TP.LOTEPREF,
		       CASE WHEN TP.LOTEPREF IS NULL THEN
		         TBAD.SEQUENCIAARQUIVO
		       ELSE TP.SEQUENCIAPREF END,
		       TP.DataPagamento,
		       TP.DATALANCAMENTO,
		       TPD.SITUACAOLEGAL,
		       tp.ContaBancaria,
		       cb.Descricao,
		       tp.banco,
		       cb.agencia,
		       tp.ocorrencia,
		       tb.Tipobloqueto,
		       tb.nossonumero,
		       tb.CODIGOBARRASEXTERNO,
		       TD.PARCELADO,
		       TAIF.AUTOINFRACAOFISCAL,
		       TAIF.EXERCICIO,
		       CASE WHEN TPL.TIPOARQUIVO = 3 THEN 'S'
		            WHEN TPL.TIPOARQUIVO = 5 THEN 'R'
		       ELSE ' ' END,
		       COMPLETASTRING((CASE WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 101) THEN '01'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 102) THEN '02'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 103) THEN '03'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 104) THEN '04'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 105) THEN '05'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 106) THEN '06'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 107) THEN '07'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 108) THEN '08'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 109) THEN '09'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 110) THEN '10'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 111) THEN '11'
		            WHEN (tdpr.GUIARECOLHIMENTO = 91) AND (tdpr.SUBDIVIDA = 112) THEN '12'
		            WHEN tdpr.GUIARECOLHIMENTO IN (41, 91, 93, 94) THEN
		              CASE WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1 THEN '12'
		              ELSE CAST((EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) - 1) AS VARCHAR(2)) END
		            WHEN (tdpr.GUIARECOLHIMENTO = 92) THEN ''
		            WHEN tdpr.GUIARECOLHIMENTO = 62 THEN
		              CASE WHEN tp.MESREFERENCIA IS NOT NULL THEN CAST(tp.MESREFERENCIA AS VARCHAR(2))
		                   WHEN TP.MESREFERENCIA IS NOT NULL THEN CAST(TP.MESREFERENCIA AS VARCHAR(2))
		                   WHEN tdp.MESREFERENCIA IS NOT NULL THEN CAST(tdp.MESREFERENCIA AS VARCHAR(2))
		                   WHEN tb.CODIGOBARRASEXTERNO IS NOT NULL THEN substring(tb.CODIGOBARRASEXTERNO, 31, 2)
		                   WHEN TBAD.MESMOVIMENTO IS NOT NULL THEN CAST(TBAD.MESMOVIMENTO AS VARCHAR(2))
		              ELSE
		                CASE WHEN EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) = 1 THEN '12'
		                 ELSE CAST((EXTRACT(MONTH FROM tdp.DATAVENCIMENTO) - 1) AS VARCHAR(2)) END
		       END END),'0','E','2'),
		       CASE WHEN (tp.LOTEPREF IS NULL) THEN 'A'
		       ELSE 'N' END,
		       CASE WHEN TP.EXERCICIOPAGAMENTO IS NOT NULL THEN
		         COMPLETASTRING(CAST(TP.ENTIDADE AS VARCHAR(2)), '0', 'E', 2) || TP.EXERCICIOPAGAMENTO || COMPLETASTRING(CAST(TP.PAGAMENTO AS VARCHAR(10)), '0', 'E', 10) || COMPLETASTRING(substring(CAST(TDPR.EXERCICIO AS VARCHAR(4)), 3, 2), '0', 'E', 2) || COMPLETASTRING(CAST(TDPR.TIPOCADASTRO AS VARCHAR(2)), '0', 'E', 2) || COMPLETASTRING(CAST(TDPR.CADASTROGERAL AS VARCHAR(8)), '0', 'E', 10) || COMPLETASTRING(CAST(TDPR.GUIARECOLHIMENTO AS VARCHAR(3)), '0', 'E', 3) || COMPLETASTRING(CAST(CASE WHEN TDPR.SUBDIVIDA >= 1000 THEN 999 ELSE TDPR.SUBDIVIDA END  AS VARCHAR(3)), '0', 'E', 3) || COMPLETASTRING(CAST(TDPR.PARCELA AS VARCHAR(4)), '0', 'E', 4)
		       ELSE '' END,
		       substring(TBAD.DETALHE,462,17),
		       substring(tb.CODIGOBARRASEXTERNO,28,17)
		ORDER BY TP.DATABAIXA,
		          tdpr.TipoCadastro,
		          tdpr.CadastroGeral,
		          tdpr.GuiaRecolhimento,
		          tdpr.SubDivida,
		          tdpr.Parcela