/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sanepar;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.sanepar.BaixaSaneparItem;
import br.com.elotech.tributos.domain.sanepar.SaneparMatricula;
import br.com.elotech.tributos.service.CadastroAvulsoService;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaAndCadastroAvulsoResponseDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdequacoesBaixaSaneparService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdequacoesBaixaSaneparService.class);
    private final CadastroAvulsoService cadastroAvulsoService;
    private static final int TIPO_DOCUMENTO_CPF = 1;
    private static final int TIPO_DOCUMENTO_CNPJ = 2;
    private static final int TAMANHO_CPF = 11;
    private static final int TAMANHO_CNPJ = 14;

    public void adequarVinculos(BaixaSaneparItem item) {
        CadastroGeral cadastro = this.incluirPessoaAndCadastro(item);
        this.vinculaMatriculaCadastro(item, cadastro);
    }

    private String adequaDocumento(BaixaSaneparItem item) {
        int tamanhoDocumento = item.getDocTipo() == 1L ? 11 : 14;
        String documento = item.getDocNumero();
        return documento.substring(documento.length() - tamanhoDocumento);
    }

    private CadastroGeral incluirPessoaAndCadastro(BaixaSaneparItem item) {
        IncluirPessoaRequestDTO pessoaRequest = new IncluirPessoaRequestDTO();
        pessoaRequest.setTipoPessoa(item.getDocTipo() == 1L ? TipoPessoa.FISICA : TipoPessoa.JURIDICA);
        pessoaRequest.setCnpjCpf(this.adequaDocumento(item));
        pessoaRequest.setNome(item.getNome());
        if (item.getDocTipo() == 2L) {
            pessoaRequest.setNomeFantasia(item.getNome());
        }
        IncluirPessoaAndCadastroAvulsoResponseDTO response = this.cadastroAvulsoService.incluirCadastroAvulsoEPessoa(pessoaRequest);
        return this.cadastroAvulsoService.buscaCadastroAvulso(response.getIdCadastro());
    }

    private void vinculaMatriculaCadastro(BaixaSaneparItem item, CadastroGeral cadastro) {
        SaneparMatricula matricula = new SaneparMatricula();
        matricula.setMatricula(item.getMatricula());
        matricula.setCadastroGeral(cadastro);
        matricula.setPrincipal(Boolean.valueOf(true));
        cadastro.getSaneparMatriculas().add(matricula);
        this.cadastroAvulsoService.save(cadastro);
    }

    @Generated
    public AdequacoesBaixaSaneparService(CadastroAvulsoService cadastroAvulsoService) {
        this.cadastroAvulsoService = cadastroAvulsoService;
    }
}

