/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.relatoriogerencial.lancamentoarrecadacaoiss;

import br.com.elotech.tributos.service.ContextService;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class LancamentoArrecadacaoIssJobStarter {
    private final JobLauncher jobLauncher;
    private final Job lancamentoArrecadacaoIssJob;
    private final ContextService contextService;

    public LancamentoArrecadacaoIssJobStarter(JobLauncher jobLauncher, @Qualifier(value="lancamentoArrecadacaoIssBatchJob") Job lancamentoArrecadacaoIssJob, ContextService contextService) {
        this.jobLauncher = jobLauncher;
        this.lancamentoArrecadacaoIssJob = lancamentoArrecadacaoIssJob;
        this.contextService = contextService;
    }

    public JobExecution startJob(Long exercicio, Long mes) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        Long entidade = this.contextService.getEntidadePrincipal();
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("entidade", entidade, true);
        jobParametersBuilder.addLong("exercicio", exercicio, true);
        jobParametersBuilder.addLong("mes", mes, true);
        jobParametersBuilder.addDate("date", new Date());
        return this.jobLauncher.run(this.lancamentoArrecadacaoIssJob, jobParametersBuilder.toJobParameters());
    }
}

