/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.rastreamento;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.dto.RastreamentoConsultaDTO;
import br.com.elotech.tributos.dto.RastreamentoDebitoDTO;
import br.com.elotech.tributos.dto.rastreamento.RastreamentoCadastroImpressaoDTO;
import br.com.elotech.tributos.report.loader.RastreamentoCadastralParamLoader;
import br.com.elotech.tributos.repository.ProprietarioRepository;
import br.com.elotech.tributos.repository.RastreamentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.PessoaNotFoundException;
import br.com.elotech.tributos.service.exception.RastreamentoException;
import br.com.elotech.tributos.service.rastreamento.RastreamentoServiceInterface;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Qualifier(value="rastreamentoGeral")
public class RastreamentoService
implements RastreamentoServiceInterface {
    private final CadastroGeralService cadastroGeralService;
    private final PessoaService pessoaService;
    private final RastreamentoRepository rastreamentoRepository;
    private final ParametroGeralService parametroGeralService;
    private final ProprietarioRepository proprietarioRepository;
    private final RastreamentoCadastralParamLoader rastreamentoCadastralParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ObjectMapper objectMapper;

    public RastreamentoService(CadastroGeralService cadastroGeralService, RastreamentoRepository rastreamentoRepository, ParametroGeralService parametroGeralService, PessoaService pessoaService, ProprietarioRepository proprietarioRepository, RastreamentoCadastralParamLoader rastreamentoCadastralParamLoader, ReportFileResolverFactory reportFileResolverFactory, ObjectMapper objectMapper) {
        this.cadastroGeralService = cadastroGeralService;
        this.rastreamentoRepository = rastreamentoRepository;
        this.parametroGeralService = parametroGeralService;
        this.pessoaService = pessoaService;
        this.proprietarioRepository = proprietarioRepository;
        this.rastreamentoCadastralParamLoader = rastreamentoCadastralParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.objectMapper = objectMapper;
    }

    public Set<RastreamentoCadastroDTO> porCadastro(RastreamentoConsultaDTO param) {
        return this.porCadastro(param.getIdCadastro());
    }

    public Set<RastreamentoCadastroDTO> porCadastro(Long idCadastro) {
        this.validarCadastro((CadastroGeral)this.cadastroGeralService.findOne((Serializable)idCadastro));
        List proprietarios = this.rastreamentoRepository.loadRastreamentoPorCadastro(idCadastro, this.consideraCadastroAvulso());
        if (this.consideraDevedorSolidario().booleanValue()) {
            proprietarios.addAll(this.rastreamentoRepository.loadRastreamentoDevedorSolidarioPorCadastro(idCadastro));
        }
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        return this.calculaSituacoesCadastro(cadastros);
    }

    public Set<RastreamentoCadastroDTO> porContribuinte(RastreamentoConsultaDTO param) {
        return this.porContribuinte(param.getIdContribuinte());
    }

    public Set<RastreamentoCadastroDTO> porContribuinte(Long idContribuinte) {
        Pessoa pessoa = this.pessoaService.findOne(idContribuinte);
        this.validarPessoa(pessoa);
        Boolean consideraCnpjRaiz = this.consideraCnpjRaiz();
        Boolean consideraCadastroAvulso = this.consideraCadastroAvulso();
        Boolean consideraSocios = this.consideraSocios();
        Boolean consideraContratoSocial = this.consideraContratoSocial();
        List proprietarios = this.rastreamentoRepository.loadRastreamentoPorCpfCnpj(pessoa.getCnpjCpf(), consideraCadastroAvulso, consideraCnpjRaiz);
        if (this.consideraDevedorSolidario().booleanValue()) {
            proprietarios.addAll(this.rastreamentoRepository.loadRastreamentoDevedorSolidarioPorCpfCnpj(pessoa.getCnpjCpf(), consideraCnpjRaiz));
        }
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        if (consideraSocios.booleanValue()) {
            cadastros.forEach(cadastro -> {
                List socios = this.rastreamentoRepository.buscaSocios(cadastro.getId());
                socios.forEach(socio -> {
                    Set cadastrosSocios = this.rastreamentoRepository.loadRastreamentoCadastrosSocios(socio.getCpfCnpj(), consideraCnpjRaiz, consideraCadastroAvulso);
                    socio.setCadastrosVinculados(cadastrosSocios.stream().filter(cadastroSocios -> !cadastroSocios.getId().equals(cadastro.getId())).collect(Collectors.toList()));
                });
                cadastro.getProprietarios().addAll(socios);
            });
            cadastros.addAll(this.rastreamentoRepository.loadRastreamentoCadastrosSocios(pessoa.getCnpjCpf(), consideraCnpjRaiz, consideraCadastroAvulso));
        }
        if (Boolean.TRUE.equals(consideraContratoSocial)) {
            List cadastrosContratoSocial = this.rastreamentoRepository.loadRastreamentoContratoSocialPorCpfCnpj(pessoa.getCnpjCpf(), consideraCnpjRaiz);
            Set cadastrosContratoSocialAgrupados = RastreamentoCadastroDTO.agruparPorCadastro((List)cadastrosContratoSocial);
            cadastros.addAll(cadastrosContratoSocialAgrupados);
        }
        return this.calculaSituacoesCadastro(cadastros);
    }

    public byte[] imprimirRastreamento(List<RastreamentoCadastroDTO> rastreamentos, Boolean isDetalhado) {
        List rastreamentoCadastroImpressaoDTOS = this.getRastreamentoCadastroImpressaoDTOS(rastreamentos, isDetalhado);
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)rastreamentoCadastroImpressaoDTOS, RastreamentoCadastroImpressaoDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.rastreamentoCadastralParamLoader).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).build();
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile("rastreamento-debitos-detalhado.jrxml")).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
    }

    public List<RastreamentoCadastroImpressaoDTO> getRastreamentoCadastroImpressaoDTOS(List<RastreamentoCadastroDTO> rastreamentos, Boolean isDetalhado) {
        return rastreamentos.stream().map(rc -> {
            RastreamentoCadastroImpressaoDTO rastreamentoCadastroImpressaoDTO = RastreamentoCadastroImpressaoDTO.toRastreamentoCadastroImpressaoDTO((RastreamentoCadastroDTO)rc);
            CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findOne((Serializable)rc.getId());
            Pessoa pessoa = (Pessoa)this.pessoaService.findById(rc.getPessoa()).orElseThrow(() -> new PessoaNotFoundException());
            Optional proprietario = this.proprietarioRepository.findByPessoaAndCadastroGeral(pessoa, cadastroGeral);
            rastreamentoCadastroImpressaoDTO.preencheDadosProprietario(proprietario, cadastroGeral.getPessoa());
            if (isDetalhado.booleanValue()) {
                List debitosRastreamento = this.rastreamentoRepository.loadDebitosRastreamento(cadastroGeral.getId());
                List debitosVencidosRastreamento = debitosRastreamento.stream().filter(rt -> rt.getVencido() != false && BigDecimal.ZERO.compareTo(rt.getValor()) < 0).collect(Collectors.toList());
                rastreamentoCadastroImpressaoDTO.setDebitosVencidos(debitosVencidosRastreamento);
                rastreamentoCadastroImpressaoDTO.setTotalValorDebitos(debitosVencidosRastreamento.stream().map(RastreamentoDebitoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            return rastreamentoCadastroImpressaoDTO;
        }).collect(Collectors.toList());
    }

    private Set<RastreamentoCadastroDTO> calculaSituacoesCadastro(Set<RastreamentoCadastroDTO> cadastros) {
        Boolean parametroCertidaoNegativaSemContrato = this.consideraCndParaDebitosAVencer();
        Boolean parametroConsideraContencioso = this.consideraContencioso();
        HashMap mapCadastros = new HashMap();
        cadastros.forEach(cadastro -> {
            this.atualizaSituacoesCadastro(mapCadastros, cadastro, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso);
            cadastro.getProprietarios().forEach(proprietario -> {
                if (Objects.nonNull(proprietario.getCadastrosVinculados())) {
                    proprietario.getCadastrosVinculados().forEach(cadastroVinculado -> this.atualizaSituacoesCadastro(mapCadastros, cadastroVinculado, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso));
                }
            });
        });
        return cadastros;
    }

    private void atualizaSituacoesCadastro(Map<Long, RastreamentoCadastroDTO> mapCadastros, RastreamentoCadastroDTO cadastro, Boolean parametroCertidaoNegativaSemContrato, Boolean parametroConsideraContencioso) {
        RastreamentoCadastroDTO cadastroMapeado = mapCadastros.computeIfAbsent(cadastro.getId(), c -> this.buscaDebitos(cadastro, parametroCertidaoNegativaSemContrato, parametroConsideraContencioso));
        cadastro.setDebitos(cadastroMapeado.getDebitos());
        cadastro.setTipoCertidaoDebitos(cadastroMapeado.getTipoCertidaoDebitos());
    }

    private RastreamentoCadastroDTO buscaDebitos(RastreamentoCadastroDTO cadastro, Boolean parametroCertidaoNegativaSemContrato, Boolean parametroConsideraContencioso) {
        cadastro.setDebitos(this.rastreamentoRepository.loadDebitosRastreamento(cadastro.getId()));
        cadastro.calculaSituacaoDebitos(parametroCertidaoNegativaSemContrato, parametroConsideraContencioso);
        return cadastro;
    }

    private Boolean emiteCertidaoCadastroMobiliario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.EMITE_CERTIDAO_CAD_MOBILIARIO);
    }

    private void validarCadastro(CadastroGeral cadastro) {
        if (Objects.isNull(cadastro)) {
            throw new CadastroNaoEncontradoException();
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)cadastro.getTipoCadastro()) && !this.emiteCertidaoCadastroMobiliario().booleanValue()) {
            throw RastreamentoException.tipoCadastroInvalido();
        }
    }

    private void validarPessoa(Pessoa pessoa) {
        if (Objects.isNull(pessoa)) {
            throw new PessoaNotFoundException();
        }
    }

    public Boolean consideraCadastroAvulso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_AVULSO_RASTREAMENTO);
    }

    private Boolean consideraDevedorSolidario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VERIFICA_DEVEDOR_SOLIDARIO_CND);
    }

    private Boolean consideraCndParaDebitosAVencer() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CERTIDAO_CND_QDO_SEM_CONTRATO);
    }

    private Boolean consideraCnpjRaiz() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CNPJ_RAIZ_RASTREAMENTO);
    }

    private Boolean consideraSocios() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VERIFICA_SOCIO_RASTREAMENTO);
    }

    private Boolean consideraContencioso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CONTENCIOSO_CND);
    }

    private Boolean consideraContratoSocial() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CONTRATO_SOCIAL_RASTREAMENTO);
    }
}

