/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.parcelametoreajuste;

import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.LoteParcelamentoReajuste;
import br.com.elotech.tributos.domain.parcelamento.TipoAtualizacaoMonetaria;
import br.com.elotech.tributos.exception.LoteParcelamentoReajusteNotFoundException;
import br.com.elotech.tributos.repository.parcelamento.AtualizacaoMonetariaRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.LoteParcelamentoReajusteService;
import java.io.Serializable;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@StepScope
@Component
public class LoteReajusteParcelamentoListener
extends StepExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoteReajusteParcelamentoListener.class);
    private final LoteParcelamentoReajusteService loteParcelamentoReajusteService;
    private final AtualizacaoMonetariaRepository atualizacaoMonetariaRepository;
    private final ContextService contextService;

    @Transactional
    public ExitStatus afterStep(StepExecution stepExecution) {
        super.afterStep(stepExecution);
        Long idLoteReajusteParcela = stepExecution.getJobParameters().getLong("idLoteReajusteParcela");
        LoteParcelamentoReajuste loteParcelamentoReajuste = this.findLoteParcelamentoReajust(idLoteReajusteParcela);
        Optional atualizacaoMonetaria = this.atualizacaoMonetariaRepository.findByEntidadeAndAnoAndMesAndLoteParcelamentoReajuste(this.contextService.getEntidadePrincipal(), Integer.valueOf(loteParcelamentoReajuste.getDataCriacao().getYear()), Integer.valueOf(loteParcelamentoReajuste.getDataCriacao().getMonthValue()), loteParcelamentoReajuste);
        if (!atualizacaoMonetaria.isPresent()) {
            log.info("Criando uma atualizacao monetaria para o lote : {}", (Object)loteParcelamentoReajuste.getId());
            AtualizacaoMonetaria atualizacaoMonetariaNew = new AtualizacaoMonetaria();
            atualizacaoMonetariaNew.setEntidade(this.contextService.getEntidadePrincipal());
            atualizacaoMonetariaNew.setData(loteParcelamentoReajuste.getDataCriacao());
            atualizacaoMonetariaNew.setAno(Integer.valueOf(loteParcelamentoReajuste.getDataCriacao().getYear()));
            atualizacaoMonetariaNew.setMes(Integer.valueOf(loteParcelamentoReajuste.getDataCriacao().getMonthValue()));
            atualizacaoMonetariaNew.setHora("");
            atualizacaoMonetariaNew.setTipo(TipoAtualizacaoMonetaria.ANUAL);
            atualizacaoMonetariaNew.setLoteParcelamentoReajuste(loteParcelamentoReajuste);
            atualizacaoMonetariaNew.setUsuario(loteParcelamentoReajuste.getUsuario());
            atualizacaoMonetariaNew.setObservacao(loteParcelamentoReajuste.getObservacao());
            this.atualizacaoMonetariaRepository.save((Object)atualizacaoMonetariaNew);
        }
        return stepExecution.getExitStatus();
    }

    private LoteParcelamentoReajuste findLoteParcelamentoReajust(Long id) {
        return (LoteParcelamentoReajuste)this.loteParcelamentoReajusteService.findById((Serializable)id).orElseThrow(() -> new LoteParcelamentoReajusteNotFoundException(id));
    }

    @Generated
    public LoteReajusteParcelamentoListener(LoteParcelamentoReajusteService loteParcelamentoReajusteService, AtualizacaoMonetariaRepository atualizacaoMonetariaRepository, ContextService contextService) {
        this.loteParcelamentoReajusteService = loteParcelamentoReajusteService;
        this.atualizacaoMonetariaRepository = atualizacaoMonetariaRepository;
        this.contextService = contextService;
    }
}

