/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoprotestocra;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.protesto.IbgeProtestoAbrangente;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoBloqueto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.dto.EntidadeDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaHeaderDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaRetornoDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaTraillerDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaTransacaoDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRelatorioRetornoDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRemessaDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRetornoConsultaDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraRetornoConsultaTituloDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.IbgeGroupDTO;
import br.com.elotech.tributos.enums.SituacaoProtesto;
import br.com.elotech.tributos.enums.SituacaoProtestoTipoRemessa;
import br.com.elotech.tributos.repository.ProtestoRemessaRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.service.IbgeProtestoAbrangenteService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ProtestoRemessaItemService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.impl.EntidadeServiceImpl;
import br.com.elotech.tributos.service.integracaoprotestocra.ArquivoTxtProtestoRemessa;
import br.com.elotech.tributos.service.integracaoprotestocra.servercra.ServerCraLocator;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.util.FileUtils;
import br.com.elotech.tributos.util.ListUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IntegracaoProtestoCraService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoProtestoCraService.class);
    private static final String TIPO_ARQUIVO_REMESSA = "B";
    private final ProtestoRemessaRepository protestoRemessaRepository;
    private final ProtestoRemessaItemService protestoRemessaItemService;
    private final ProtestoService protestoService;
    private final ParametroGeralService parametroGeralService;
    private final EntidadeServiceImpl entidadeService;
    private final IbgeProtestoAbrangenteService ibgeProtestoAbrangenteService;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final ServerCraLocator serverCraLocator;
    private final ResolversHandler resolversHandler;
    private Map<IbgeGroupDTO, List<ProtestoRemessaItem>> protestosByIbge;
    private static final String DATE_FORMAT = "ddMMyyyy";

    public CraRemessaDTO getCraRemessaDTO(ProtestoRemessa protestoRemessa) {
        List protestoRemessaItems = this.protestoRemessaItemService.findByProtestoRemessa(protestoRemessa);
        this.protestosByIbge = protestoRemessaItems.stream().collect(Collectors.groupingBy(arg_0 -> this.groupingByIbge(arg_0)));
        return this.createCraRemessaDTO(this.protestosByIbge);
    }

    public Arquivo uploadArquivoTxtRemessa(Long exercicio, Long remessa, CraRemessaDTO craRemessaDTO) {
        log.debug("Iniciando gera\u00e7\u00e3o do arquivo txt {} de remessa {} / {}", new Object[]{craRemessaDTO.getNomeArquivo(), remessa, exercicio});
        ArquivoTxtProtestoRemessa arquivoTxtProtestoRemessa = new ArquivoTxtProtestoRemessa(craRemessaDTO.getNomeArquivo());
        craRemessaDTO.getComarcas().forEach(comarca -> {
            arquivoTxtProtestoRemessa.gerarCabecalho(comarca.getHeader());
            ListUtils.forEachWithCounter((Iterable)comarca.getTransacoes(), (index, item) -> {
                int quantidadeTotalTransacoes = comarca.getTransacoes().size();
                Optional<String> dataEmissao = Optional.ofNullable(craRemessaDTO.getDataEmissao());
                dataEmissao.ifPresent(arg_0 -> ((CraComarcaTransacaoDTO)item).setDataEmissaoTitulo(arg_0));
                log.trace("Inserindo dados do item {}/{}", index, (Object)quantidadeTotalTransacoes);
                arquivoTxtProtestoRemessa.gerarDetalhe(item);
            });
            arquivoTxtProtestoRemessa.gerarRodape(comarca.getTrailler());
        });
        arquivoTxtProtestoRemessa.finalizarGeracaoArquivo();
        log.debug("Finalizou montagem do arquivo txt de protesto remessa {} / {} ", (Object)remessa, (Object)exercicio);
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(arquivoTxtProtestoRemessa.getNomeArquivo()).content((InputStream)new ByteArrayInputStream(arquivoTxtProtestoRemessa.getOutStream().toByteArray())).contentType(ContentType.APPLICATION_ZIP).build();
        Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
        log.debug("Finalizado upload para o s3 do arquivo txt de protesto remessa");
        return arquivo;
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    public void gerarArquivoTxtRemessa(ProtestoRemessa protestoRemessa, LocalDate dataEmissaoPersonalizada) {
        CraRemessaDTO craRemessaDTO = this.getCraRemessaDTO(protestoRemessa);
        if (dataEmissaoPersonalizada != null) {
            craRemessaDTO.setDataEmissao(dataEmissaoPersonalizada.format(DateTimeFormatter.ofPattern(DATE_FORMAT)));
        }
        try {
            Arquivo arquivo = this.uploadArquivoTxtRemessa(protestoRemessa.getExercicio(), protestoRemessa.getRemessa(), craRemessaDTO);
            log.debug("Atualizando remessa dos protestos ap\u00f3s a gera\u00e7\u00e3o do arquivo e envio para o s3");
            this.updateProtestoRemessaAfterEnviarRemessa(protestoRemessa, craRemessaDTO, null, null, arquivo.getId());
            log.debug("Atualizando situa\u00e7\u00e3o dos protestos para gerado");
            this.updateSituacaoProtestosAfterEnviarRemessa(this.protestosByIbge);
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao gerar o arquivo txt. " + e.getMessage());
        }
    }

    public CraRelatorioRetornoDTO enviarRemessa(ProtestoRemessa protestoRemessa) {
        CraRemessaDTO craRemessaDTO = this.getCraRemessaDTO(protestoRemessa);
        String userArq = craRemessaDTO.getNomeArquivo();
        String xmlEnvio = new String(this.marshalEnvio(craRemessaDTO).getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
        URL url = this.getUrlFrom(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.URL_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue()));
        String usuario = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.USUARIO_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String senha = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.SENHA_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        AtomicReference<String> xmlRetorno = new AtomicReference<String>();
        try {
            log.debug("Enviando XML para o CRA. Credenciais da Web Service: [URL: {}, Usu\u00e1rio: {}, Senha: {}]", new Object[]{url, usuario, senha});
            xmlRetorno.set(this.serverCraLocator.getServerCraPort(url, usuario, senha).remessa(userArq, xmlEnvio));
            log.debug("Envio do XML finalizado");
        }
        catch (Exception e) {
            try {
                throw new EloValidationException("Erro ao enviar XML de remessa para o CRA. " + e.getMessage());
            }
            catch (Throwable throwable) {
                CraRelatorioRetornoDTO craRelatorioRetornoDTO = Objects.nonNull(xmlRetorno.get()) ? this.unmarshalRetorno((String)xmlRetorno.get()) : null;
                log.debug("Atualizando remessa dos protestos ap\u00f3s o envio para o CRA");
                this.updateProtestoRemessaAfterEnviarRemessa(protestoRemessa, craRemessaDTO, xmlEnvio, (String)xmlRetorno.get(), null);
                log.debug("Atualizando protestos para o(s) seguinte(s) munic\u00edpio(s): {}", this.protestosByIbge.keySet());
                this.updateProtestosAfterEnviarRemessa(this.protestosByIbge, craRelatorioRetornoDTO);
                throw throwable;
            }
        }
        CraRelatorioRetornoDTO craRelatorioRetornoDTO = Objects.nonNull(xmlRetorno.get()) ? this.unmarshalRetorno((String)xmlRetorno.get()) : null;
        log.debug("Atualizando remessa dos protestos ap\u00f3s o envio para o CRA");
        this.updateProtestoRemessaAfterEnviarRemessa(protestoRemessa, craRemessaDTO, xmlEnvio, (String)xmlRetorno.get(), null);
        log.debug("Atualizando protestos para o(s) seguinte(s) munic\u00edpio(s): {}", this.protestosByIbge.keySet());
        this.updateProtestosAfterEnviarRemessa(this.protestosByIbge, craRelatorioRetornoDTO);
        return craRelatorioRetornoDTO;
    }

    public CraRetornoConsultaTituloDTO consultarRemessa(Protesto protesto) throws MalformedURLException, JAXBException, RemoteException {
        if (Objects.isNull(protesto)) {
            throw new EloValidationException("O protesto \u00e9 obrigat\u00f3rio para a consulta de t\u00edtulos no CRA.");
        }
        ProtestoRemessaItem protestoRemessaItem = (ProtestoRemessaItem)this.protestoRemessaItemService.findByProtesto(protesto).orElseThrow(() -> new EloValidationException(String.format("Item da remessa do protesto n\u00e3o encontrado para o protesto %d", protesto.getId())));
        URL url = new URL(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.URL_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue()));
        String usuario = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.USUARIO_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String senha = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.SENHA_WEB_SERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String nossoNumero = protestoRemessaItem.getId().toString();
        String numeroTitulo = String.format("%d%d", protestoRemessaItem.getExercicioDocumento(), protestoRemessaItem.getDocumento());
        AtomicReference<String> xmlRetorno = new AtomicReference<String>(this.serverCraLocator.getServerCraPort(url, usuario, senha).consulta(nossoNumero, numeroTitulo));
        CraRetornoConsultaDTO craRetornoConsultaDTO = this.unmarshalRetornoConsulta(xmlRetorno.get());
        if (craRetornoConsultaDTO.isRetornoErro()) {
            throw new EloValidationException(craRetornoConsultaDTO.getOcorrencia());
        }
        if (craRetornoConsultaDTO.getTitulo().getSituacao().equals(protesto.getSituacao().getDescricaoCRA())) {
            return craRetornoConsultaDTO.getTitulo();
        }
        protesto.setSituacao(SituacaoProtesto.fromDescricaoCRA((String)craRetornoConsultaDTO.getTitulo().getSituacao()));
        this.protestoService.save((EloEntity)protesto, null);
        return craRetornoConsultaDTO.getTitulo();
    }

    private CraRemessaDTO createCraRemessaDTO(Map<IbgeGroupDTO, List<ProtestoRemessaItem>> protestosByIbge) {
        EntidadeDTO entidadeDTO = this.getInfoEntidadePrincipal();
        String codApresentante = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.CODIGO_CONVENIO_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String usarVencimentoBloqueto = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.VENCIMENTO_BLOQUETO_REMESSA_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        List comarcas = protestosByIbge.entrySet().stream().map(entry -> this.createComarcaDTO(entidadeDTO, (IbgeGroupDTO)entry.getKey(), codApresentante, usarVencimentoBloqueto, (List)entry.getValue())).collect(Collectors.toList());
        return CraRemessaDTO.builder().nomeArquivo(this.createNomeArquivoRemessa(codApresentante)).comarcas(comarcas).build();
    }

    private String getDataVencimentoTitulo(String usarVencimentoBloqueto, ProtestoRemessaItem protesto) {
        Optional<LocalDate> dataValidade = protesto.getProtesto().getProtestoBloquetos().stream().filter(Objects::nonNull).map(ProtestoBloqueto::getDataVencimento).min(LocalDate::compareTo);
        return SimNao.SIM.getSigla().equals(usarVencimentoBloqueto) && dataValidade.isPresent() ? dataValidade.map(dv -> dv.format(DateTimeFormatter.ofPattern(DATE_FORMAT))).orElse("99999999") : "99999999";
    }

    private IbgeGroupDTO groupingByIbge(ProtestoRemessaItem protesto) {
        Cidade cidade = protesto.getProtesto().getDocumento().getPessoa().getEnderecoPrincipal().getCidade();
        Long ibge = cidade.getCodigoIbge();
        IbgeProtestoAbrangente ibgeProtestoAbrangente = this.ibgeProtestoAbrangenteService.findByCodIbgeComarcaAbrangente(ibge);
        if (Objects.isNull(ibgeProtestoAbrangente)) {
            return IbgeGroupDTO.builder().ibge(ibge).cidade(cidade.getDescricao()).build();
        }
        return IbgeGroupDTO.builder().ibge(ibgeProtestoAbrangente.getCodIbgeComarcaPrincipal()).cidade(ibgeProtestoAbrangente.getDescricaoMunicipioPrincipal()).build();
    }

    private CraComarcaDTO createComarcaDTO(EntidadeDTO entidadeDTO, IbgeGroupDTO ibgeGroupDTO, String codApresentante, String usarVencimentoBloqueto, List<ProtestoRemessaItem> protestos) {
        boolean geraInforProprietario = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.GERA_INFO_PROPRIETARIO_ARQ_REMESSA);
        List protestosSemVinculoOuPrincipal = geraInforProprietario ? protestos.stream().sorted(Comparator.comparing(ProtestoRemessaItem::isSemVinculoOrPrincipal).reversed()).collect(Collectors.toList()) : protestos.stream().filter(ProtestoRemessaItem::isSemVinculoOrPrincipal).collect(Collectors.toList());
        Long qtdeRegistrosTransacao = protestos.size();
        Long qtdeTitulosRemessa = protestosSemVinculoOuPrincipal.size();
        String codIbgeCartorio = ibgeGroupDTO.getIbge().toString();
        String sequenceName = String.format("s05protesto_cidade_%s", codIbgeCartorio);
        Long sequencialRemessaCidade = this.sequenceGeneratorRepository.getNextVal(sequenceName);
        log.debug("Gerando comarca da remessa de protestos. C\u00f3digo do Munic\u00edpio: {}, Nome da Sequ\u00eancia: {}, Valor: {}", new Object[]{codIbgeCartorio, sequenceName, sequencialRemessaCidade});
        CraComarcaHeaderDTO header = this.createCraComarcaHeaderDTO(entidadeDTO.getNome(), sequencialRemessaCidade, codIbgeCartorio, codApresentante, qtdeRegistrosTransacao, qtdeTitulosRemessa);
        List transacoes = this.createCraComarcaTransacaoDTOS(header, entidadeDTO, ibgeGroupDTO.getCidade(), usarVencimentoBloqueto, protestosSemVinculoOuPrincipal);
        CraComarcaTraillerDTO trailler = this.createCraComarcaTraillerDTO(header, transacoes);
        return CraComarcaDTO.builder().codigoMunicipio(codIbgeCartorio).header(header).transacoes(transacoes).trailler(trailler).build();
    }

    private CraComarcaHeaderDTO createCraComarcaHeaderDTO(String nomeApresentante, Long sequencialRemessaCidade, String codIbgeCartorio, String codApresentante, Long qtdeRegistrosTransacao, Long qtdeTitulosRemessa) {
        return CraComarcaHeaderDTO.from((String)nomeApresentante, (Long)sequencialRemessaCidade, (String)codIbgeCartorio, (String)codApresentante, (Long)qtdeRegistrosTransacao, (Long)qtdeTitulosRemessa);
    }

    private List<CraComarcaTransacaoDTO> createCraComarcaTransacaoDTOS(CraComarcaHeaderDTO craComarcaHeaderDTO, EntidadeDTO entidadeDTO, String pracaPagamento, String usarVencimentoBloqueto, List<ProtestoRemessaItem> protestoRemessaItems) {
        AtomicLong sequencialRegistro = new AtomicLong(craComarcaHeaderDTO.getSequencialRegistro());
        ArrayList<CraComarcaTransacaoDTO> transacoes = new ArrayList<CraComarcaTransacaoDTO>();
        protestoRemessaItems.forEach(protestoRemessaItem -> {
            AtomicLong sequencialDevedoresNoMesmoTitulo = new AtomicLong(1L);
            String numTitulo = String.format("%s%s", protestoRemessaItem.getExercicioDocumento(), protestoRemessaItem.getDocumento());
            String imagemDocumentos = this.findImagemDocumentos(protestoRemessaItem.getProtesto());
            for (CraComarcaTransacaoDTO transacao : transacoes) {
                if (!numTitulo.equals(transacao.getNumTitulo())) continue;
                sequencialDevedoresNoMesmoTitulo.incrementAndGet();
            }
            transacoes.add(CraComarcaTransacaoDTO.from((ProtestoRemessaItem)protestoRemessaItem, (String)imagemDocumentos, (String)craComarcaHeaderDTO.getCodApresentante(), (String)pracaPagamento, (EntidadeDTO)entidadeDTO, (String)this.getDataVencimentoTitulo(usarVencimentoBloqueto, protestoRemessaItem), (Long)sequencialDevedoresNoMesmoTitulo.get(), (Long)sequencialRegistro.incrementAndGet()));
        });
        return transacoes;
    }

    private String findImagemDocumentos(Protesto protesto) {
        byte[] zip = FileUtils.zipBytes((String)this.createNomeArquivoZip(protesto), (byte[])this.protestoService.findTermoProtestoS3(protesto));
        return Base64.getEncoder().encodeToString(zip);
    }

    private String createNomeArquivoZip(Protesto protesto) {
        return String.format("termo-protesto_%s_%s_%s", protesto.getDocumento().getDocumento(), protesto.getEntidade(), protesto.getExercicio());
    }

    private CraComarcaTraillerDTO createCraComarcaTraillerDTO(CraComarcaHeaderDTO header, List<CraComarcaTransacaoDTO> transacoes) {
        Long qtdeHeaders = 1L;
        Long qtdeTraillers = 1L;
        Long sequencialRegistroTrailler = header.getQtdeTitulosRemessa() + qtdeTraillers + qtdeHeaders;
        BigDecimal somatoriaSaldoTitulo = transacoes.stream().map(CraComarcaTransacaoDTO::getValorTitulo).reduce(BigDecimal.ZERO, BigDecimal::add);
        return CraComarcaTraillerDTO.from((String)header.getNomeApresentante(), (String)header.getCodApresentante(), (Long)header.getSomatoriaSeguranca(), (Long)sequencialRegistroTrailler, (BigDecimal)somatoriaSaldoTitulo);
    }

    private EntidadeDTO getInfoEntidadePrincipal() {
        return (EntidadeDTO)this.entidadeService.getInfoEntidadePrincipal().orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a entidade principal"));
    }

    private String createNomeArquivoRemessa(String codApresentante) {
        LocalDate dataAtual = LocalDate.now();
        String dataNomeArquivo = dataAtual.format(DateTimeFormatter.ofPattern("ddMM.yy"));
        Long qtdRemessaDiaAtual = this.protestoRemessaRepository.getQtdRemessaPorData(dataAtual, SituacaoProtestoTipoRemessa.R);
        Long qtdMaximaRemessaPorDia = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.QTD_MAX_REMESSA_DIA_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Long sequencialArquivo = qtdRemessaDiaAtual + 1L;
        if (qtdMaximaRemessaPorDia > 0L && qtdRemessaDiaAtual >= qtdMaximaRemessaPorDia) {
            throw new EloValidationException(String.format("A quantidade m\u00e1xima de remessas para este tipo j\u00e1 foi atingida para a data atual. Quantidade encontrada: %d remessa(s) enviada(s). Limite por dia: %d remessa(s).", qtdRemessaDiaAtual, qtdMaximaRemessaPorDia));
        }
        return String.format("%s%s%s%d", TIPO_ARQUIVO_REMESSA, codApresentante, dataNomeArquivo, sequencialArquivo);
    }

    private String marshalEnvio(CraRemessaDTO craRemessaDTO) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CraRemessaDTO.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)craRemessaDTO, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao converter objeto em XML. " + e.getMessage());
        }
    }

    private URL getUrlFrom(String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException mee) {
            throw new EloValidationException("Erro ao converter texto em URL. " + mee.getMessage());
        }
    }

    private CraRelatorioRetornoDTO unmarshalRetorno(String xmlRetorno) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CraRelatorioRetornoDTO.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (CraRelatorioRetornoDTO)unmarshaller.unmarshal((Reader)new StringReader(xmlRetorno));
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao converter XML de retorno do CRA. " + e.getMessage());
        }
    }

    private void updateSituacaoProtestosAfterEnviarRemessa(Map<IbgeGroupDTO, List<ProtestoRemessaItem>> protestosByIbge) {
        for (Map.Entry<IbgeGroupDTO, List<ProtestoRemessaItem>> entry : protestosByIbge.entrySet()) {
            List<ProtestoRemessaItem> protestosRemessaItem = entry.getValue();
            List<Protesto> protestos = protestosRemessaItem.stream().map(ProtestoRemessaItem::getProtesto).collect(Collectors.toList());
            protestos.forEach(p -> p.setSituacao(SituacaoProtesto.GERADO));
            this.protestoService.saveAll(protestos);
        }
    }

    private void updateProtestosAfterEnviarRemessa(Map<IbgeGroupDTO, List<ProtestoRemessaItem>> protestosByIbge, CraRelatorioRetornoDTO craRelatorioRetornoDTO) {
        if (Objects.nonNull(craRelatorioRetornoDTO) && Objects.nonNull(craRelatorioRetornoDTO.getComarcas())) {
            craRelatorioRetornoDTO.getComarcas().stream().filter(c -> {
                log.debug("C\u00f3digo de Munic\u00edpio: {}, Qtde. Registros: {}, Registros V\u00e1lidos: {}", new Object[]{c.getCodigoMunicipio(), c.getTotalRegistros(), c.isRegistrosOk()});
                return c.isRegistrosOk();
            }).map(CraComarcaRetornoDTO::getCodigoMunicipio).map(Long::parseLong).forEach(ibge -> {
                List<Protesto> protestos = ((List)protestosByIbge.get(IbgeGroupDTO.builder().ibge(ibge).build())).stream().map(ProtestoRemessaItem::getProtesto).collect(Collectors.toList());
                protestos.forEach(p -> p.setSituacao(SituacaoProtesto.GERADO));
                this.protestoService.saveAll(protestos);
            });
        }
    }

    private void updateProtestoRemessaAfterEnviarRemessa(ProtestoRemessa protestoRemessa, CraRemessaDTO craRemessaDTO, String xmlEnvio, String xmlRetorno, UUID idArquivo) {
        protestoRemessa.setArqenvData(LocalDate.parse(((CraComarcaDTO)craRemessaDTO.getComarcas().get(0)).getHeader().getDataEnvioRemessa(), DateTimeFormatter.ofPattern(DATE_FORMAT)));
        protestoRemessa.setArqenvUsuario(protestoRemessa.getUsuario());
        protestoRemessa.setArqenvArquivo(xmlEnvio != null ? xmlEnvio.getBytes() : null);
        protestoRemessa.setArqenvArquivonome(craRemessaDTO.getNomeArquivo());
        protestoRemessa.setTotalRegistros(craRemessaDTO.getTotalRegistros());
        protestoRemessa.setXmlRetorno(xmlRetorno);
        protestoRemessa.setArqenvIdArquivo(idArquivo);
        this.protestoRemessaRepository.save((Object)protestoRemessa);
    }

    private CraRetornoConsultaDTO unmarshalRetornoConsulta(String xmlRetorno) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CraRetornoConsultaDTO.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (CraRetornoConsultaDTO)unmarshaller.unmarshal((Reader)new StringReader(xmlRetorno));
    }

    @Generated
    public IntegracaoProtestoCraService(ProtestoRemessaRepository protestoRemessaRepository, ProtestoRemessaItemService protestoRemessaItemService, ProtestoService protestoService, ParametroGeralService parametroGeralService, EntidadeServiceImpl entidadeService, IbgeProtestoAbrangenteService ibgeProtestoAbrangenteService, SequenceGeneratorRepository sequenceGeneratorRepository, ServerCraLocator serverCraLocator, ResolversHandler resolversHandler) {
        this.protestoRemessaRepository = protestoRemessaRepository;
        this.protestoRemessaItemService = protestoRemessaItemService;
        this.protestoService = protestoService;
        this.parametroGeralService = parametroGeralService;
        this.entidadeService = entidadeService;
        this.ibgeProtestoAbrangenteService = ibgeProtestoAbrangenteService;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.serverCraLocator = serverCraLocator;
        this.resolversHandler = resolversHandler;
    }
}

